/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class JFastLabel
extends JComponent {
    private String m_text;
    private int m_valign = 1;
    private int m_halign = 2;
    private int m_fheight = -1;
    private boolean m_quality = false;

    public JFastLabel() {
        this(null);
    }

    public JFastLabel(String string) {
        this.m_text = string;
        this.setFont(this.getFont());
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String string) {
        this.m_text = string;
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.m_fheight = -1;
    }

    public void setVerticalAlignment(int n) {
        this.m_valign = n;
        this.m_fheight = -1;
    }

    public void setHorizontalAlignment(int n) {
        this.m_halign = n;
    }

    public boolean getHighQuality() {
        return this.m_quality;
    }

    public void setHighQuality(boolean bl) {
        this.m_quality = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        FontMetrics fontMetrics;
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        if (this.m_fheight == -1) {
            fontMetrics = graphics.getFontMetrics(this.getFont());
            if (this.m_valign == 3) {
                this.m_fheight = fontMetrics.getDescent();
            } else if (this.m_valign == 1) {
                this.m_fheight = fontMetrics.getAscent();
            }
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(insets.left, insets.top, n, n2);
        if (this.m_text == null) {
            return;
        }
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        n2 = this.m_valign == 3 ? n2 - this.m_fheight - insets.bottom : insets.top + this.m_fheight;
        switch (this.m_halign) {
            case 4: {
                fontMetrics = graphics.getFontMetrics(this.getFont());
                n = n - insets.right - fontMetrics.stringWidth(this.m_text);
                break;
            }
            case 0: {
                fontMetrics = graphics.getFontMetrics(this.getFont());
                n = insets.left + n / 2 - fontMetrics.stringWidth(this.m_text) / 2;
                break;
            }
            default: {
                n = insets.left;
            }
        }
        if (this.m_quality) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics.drawString(this.m_text, n, n2);
    }
}

