/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.io;

import java.io.PrintWriter;
import java.util.ArrayList;

public class XMLWriter {
    private PrintWriter m_out;
    private int m_bias = 0;
    private int m_tab;
    private ArrayList m_tagStack = new ArrayList();
    private static final char LOWER_RANGE = ' ';
    private static final char UPPER_RANGE = '\u007f';
    private static final char[] VALID_CHARS = new char[]{'\t', '\n', '\r'};
    private static final char[] INVALID = new char[]{'<', '>', '\"', '\'', '&'};
    private static final String[] VALID = new String[]{"&lt;", "&gt;", "&quot;", "&apos;", "&amp;"};

    public XMLWriter(PrintWriter printWriter) {
        this(printWriter, 2);
    }

    public XMLWriter(PrintWriter printWriter, int n) {
        this.m_out = printWriter;
        this.m_tab = 2;
    }

    public void print(String string) {
        this.m_out.print(string);
    }

    public void println(String string) {
        this.m_out.print(string);
        this.m_out.print("\n");
    }

    public void println() {
        this.m_out.print("\n");
    }

    public void begin() {
        this.m_out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.println();
    }

    public void begin(String string, int n) {
        this.begin();
        this.m_out.print(string);
        this.m_bias = n;
    }

    public void comment(String string) {
        this.spacing();
        this.m_out.print("<!-- ");
        this.m_out.print(string);
        this.m_out.print(" -->");
        this.println();
    }

    protected void tag(String string, String[] stringArray, String[] stringArray2, int n, boolean bl) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(string);
        for (int i = 0; i < n; ++i) {
            this.m_out.print(' ');
            this.m_out.print(stringArray[i]);
            this.m_out.print('=');
            this.m_out.print('\"');
            this.escapeString(stringArray2[i]);
            this.m_out.print('\"');
        }
        if (bl) {
            this.m_out.print('/');
        }
        this.m_out.print('>');
        this.println();
        if (!bl) {
            this.m_tagStack.add(string);
        }
    }

    public void tag(String string, String[] stringArray, String[] stringArray2, int n) {
        this.tag(string, stringArray, stringArray2, n, true);
    }

    public void start(String string, String[] stringArray, String[] stringArray2, int n) {
        this.tag(string, stringArray, stringArray2, n, false);
    }

    protected void tag(String string, String string2, String string3, boolean bl) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(string);
        this.m_out.print(' ');
        this.m_out.print(string2);
        this.m_out.print('=');
        this.m_out.print('\"');
        this.escapeString(string3);
        this.m_out.print('\"');
        if (bl) {
            this.m_out.print('/');
        }
        this.m_out.print('>');
        this.println();
        if (!bl) {
            this.m_tagStack.add(string);
        }
    }

    public void tag(String string, String string2, String string3) {
        this.tag(string, string2, string3, true);
    }

    public void start(String string, String string2, String string3) {
        this.tag(string, string2, string3, false);
    }

    protected void tag(String string, ArrayList arrayList, ArrayList arrayList2, int n, boolean bl) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(string);
        for (int i = 0; i < n; ++i) {
            this.m_out.print(' ');
            this.m_out.print((String)arrayList.get(i));
            this.m_out.print('=');
            this.m_out.print('\"');
            this.escapeString((String)arrayList2.get(i));
            this.m_out.print('\"');
        }
        if (bl) {
            this.m_out.print('/');
        }
        this.m_out.print('>');
        this.println();
        if (!bl) {
            this.m_tagStack.add(string);
        }
    }

    public void tag(String string, ArrayList arrayList, ArrayList arrayList2, int n) {
        this.tag(string, arrayList, arrayList2, n, true);
    }

    public void start(String string, ArrayList arrayList, ArrayList arrayList2, int n) {
        this.tag(string, arrayList, arrayList2, n, false);
    }

    public void start(String string) {
        this.tag(string, (String[])null, null, 0, false);
    }

    public void end() {
        String string = (String)this.m_tagStack.remove(this.m_tagStack.size() - 1);
        this.spacing();
        this.m_out.print('<');
        this.m_out.print('/');
        this.m_out.print(string);
        this.m_out.print('>');
        this.println();
    }

    public void contentTag(String string, String string2, String string3, String string4) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(string);
        this.m_out.print(' ');
        this.m_out.print(string2);
        this.m_out.print('=');
        this.m_out.print('\"');
        this.escapeString(string3);
        this.m_out.print('\"');
        this.m_out.print('>');
        this.escapeString(string4);
        this.m_out.print('<');
        this.m_out.print('/');
        this.m_out.print(string);
        this.m_out.print('>');
        this.println();
    }

    public void contentTag(String string, String string2) {
        this.spacing();
        this.m_out.print('<');
        this.m_out.print(string);
        this.m_out.print('>');
        this.escapeString(string2);
        this.m_out.print('<');
        this.m_out.print('/');
        this.m_out.print(string);
        this.m_out.print('>');
        this.println();
    }

    public void content(String string) {
        this.escapeString(string);
    }

    public void finish() {
        this.m_bias = 0;
        this.m_out.flush();
    }

    public void finish(String string) {
        this.m_bias = 0;
        this.m_out.print(string);
        this.m_out.flush();
    }

    public void spacing() {
        int n = this.m_bias + this.m_tagStack.size() * this.m_tab;
        for (int i = 0; i < n; ++i) {
            this.m_out.print(' ');
        }
    }

    protected void escapeString(String string) {
        if (string == null) {
            this.m_out.print("null");
            return;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ' && c != VALID_CHARS[0] && c != VALID_CHARS[1] && c != VALID_CHARS[2] || c > '\u007f') {
                this.m_out.print("&#");
                this.m_out.print(Integer.toString(c));
                this.m_out.print(';');
                continue;
            }
            boolean bl = true;
            for (int j = INVALID.length - 1; j >= 0; --j) {
                if (INVALID[j] != c) continue;
                bl = false;
                this.m_out.print(VALID[j]);
                break;
            }
            if (!bl) continue;
            this.m_out.print(c);
        }
    }
}

