/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;

public class NBodyForce
extends AbstractForce {
    private static String[] pnames = new String[]{"GravitationalConstant", "Distance", "BarnesHutTheta"};
    public static final float DEFAULT_GRAV_CONSTANT = -1.0f;
    public static final float DEFAULT_MIN_GRAV_CONSTANT = -10.0f;
    public static final float DEFAULT_MAX_GRAV_CONSTANT = 10.0f;
    public static final float DEFAULT_DISTANCE = -1.0f;
    public static final float DEFAULT_MIN_DISTANCE = -1.0f;
    public static final float DEFAULT_MAX_DISTANCE = 500.0f;
    public static final float DEFAULT_THETA = 0.9f;
    public static final float DEFAULT_MIN_THETA = 0.0f;
    public static final float DEFAULT_MAX_THETA = 1.0f;
    public static final int GRAVITATIONAL_CONST = 0;
    public static final int MIN_DISTANCE = 1;
    public static final int BARNES_HUT_THETA = 2;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private QuadTreeNodeFactory factory = new QuadTreeNodeFactory();
    private QuadTreeNode root;
    private Random rand = new Random(12345678L);

    public NBodyForce() {
        this(-1.0f, -1.0f, 0.9f);
    }

    public NBodyForce(float f, float f2, float f3) {
        this.params = new float[]{f, f2, f3};
        this.minValues = new float[]{-10.0f, -1.0f, 0.0f};
        this.maxValues = new float[]{10.0f, 500.0f, 1.0f};
        this.root = this.factory.getQuadTreeNode();
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return pnames;
    }

    private void setBounds(float f, float f2, float f3, float f4) {
        this.xMin = f;
        this.yMin = f2;
        this.xMax = f3;
        this.yMax = f4;
    }

    public void clear() {
        this.clearHelper(this.root);
        this.root = this.factory.getQuadTreeNode();
    }

    private void clearHelper(QuadTreeNode quadTreeNode) {
        for (int i = 0; i < quadTreeNode.children.length; ++i) {
            if (quadTreeNode.children[i] == null) continue;
            this.clearHelper(quadTreeNode.children[i]);
        }
        this.factory.reclaim(quadTreeNode);
    }

    @Override
    public void init(ForceSimulator forceSimulator) {
        float f;
        this.clear();
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        float f5 = Float.MIN_VALUE;
        Iterator iterator = forceSimulator.getItems();
        while (iterator.hasNext()) {
            ForceItem forceItem = (ForceItem)iterator.next();
            f = forceItem.location[0];
            float f6 = forceItem.location[1];
            if (f < f2) {
                f2 = f;
            }
            if (f6 < f3) {
                f3 = f6;
            }
            if (f > f4) {
                f4 = f;
            }
            if (!(f6 > f5)) continue;
            f5 = f6;
        }
        float f7 = f4 - f2;
        f = f5 - f3;
        if (f7 > f) {
            f5 = f3 + f7;
        } else {
            f4 = f2 + f;
        }
        this.setBounds(f2, f3, f4, f5);
        iterator = forceSimulator.getItems();
        while (iterator.hasNext()) {
            ForceItem forceItem = (ForceItem)iterator.next();
            this.insert(forceItem);
        }
        this.calcMass(this.root);
    }

    public void insert(ForceItem forceItem) {
        try {
            this.insert(forceItem, this.root, this.xMin, this.yMin, this.xMax, this.yMax);
        }
        catch (StackOverflowError stackOverflowError) {
            stackOverflowError.printStackTrace();
        }
    }

    private void insert(ForceItem forceItem, QuadTreeNode quadTreeNode, float f, float f2, float f3, float f4) {
        if (quadTreeNode.hasChildren) {
            this.insertHelper(forceItem, quadTreeNode, f, f2, f3, f4);
        } else if (quadTreeNode.value != null) {
            if (NBodyForce.isSameLocation(quadTreeNode.value, forceItem)) {
                this.insertHelper(forceItem, quadTreeNode, f, f2, f3, f4);
            } else {
                ForceItem forceItem2 = quadTreeNode.value;
                quadTreeNode.value = null;
                this.insertHelper(forceItem2, quadTreeNode, f, f2, f3, f4);
                this.insertHelper(forceItem, quadTreeNode, f, f2, f3, f4);
            }
        } else {
            quadTreeNode.value = forceItem;
        }
    }

    private static boolean isSameLocation(ForceItem forceItem, ForceItem forceItem2) {
        float f = Math.abs(forceItem.location[0] - forceItem2.location[0]);
        float f2 = Math.abs(forceItem.location[1] - forceItem2.location[1]);
        return (double)f < 0.01 && (double)f2 < 0.01;
    }

    private void insertHelper(ForceItem forceItem, QuadTreeNode quadTreeNode, float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7 = forceItem.location[0];
        float f8 = (f + f3) / 2.0f;
        int n = (f7 >= f8 ? 1 : 0) + ((f6 = forceItem.location[1]) >= (f5 = (f2 + f4) / 2.0f) ? 2 : 0);
        if (quadTreeNode.children[n] == null) {
            quadTreeNode.children[n] = this.factory.getQuadTreeNode();
            quadTreeNode.hasChildren = true;
        }
        if (n == 1 || n == 3) {
            f = f8;
        } else {
            f3 = f8;
        }
        if (n > 1) {
            f2 = f5;
        } else {
            f4 = f5;
        }
        this.insert(forceItem, quadTreeNode.children[n], f, f2, f3, f4);
    }

    private void calcMass(QuadTreeNode quadTreeNode) {
        float f = 0.0f;
        float f2 = 0.0f;
        quadTreeNode.mass = 0.0f;
        if (quadTreeNode.hasChildren) {
            for (int i = 0; i < quadTreeNode.children.length; ++i) {
                if (quadTreeNode.children[i] == null) continue;
                this.calcMass(quadTreeNode.children[i]);
                quadTreeNode.mass += quadTreeNode.children[i].mass;
                f += quadTreeNode.children[i].mass * quadTreeNode.children[i].com[0];
                f2 += quadTreeNode.children[i].mass * quadTreeNode.children[i].com[1];
            }
        }
        if (quadTreeNode.value != null) {
            quadTreeNode.mass += quadTreeNode.value.mass;
            f += quadTreeNode.value.mass * quadTreeNode.value.location[0];
            f2 += quadTreeNode.value.mass * quadTreeNode.value.location[1];
        }
        quadTreeNode.com[0] = f / quadTreeNode.mass;
        quadTreeNode.com[1] = f2 / quadTreeNode.mass;
    }

    @Override
    public void getForce(ForceItem forceItem) {
        try {
            this.forceHelper(forceItem, this.root, this.xMin, this.yMin, this.xMax, this.yMax);
        }
        catch (StackOverflowError stackOverflowError) {
            stackOverflowError.printStackTrace();
        }
    }

    private void forceHelper(ForceItem forceItem, QuadTreeNode quadTreeNode, float f, float f2, float f3, float f4) {
        boolean bl;
        float f5 = quadTreeNode.com[0] - forceItem.location[0];
        float f6 = quadTreeNode.com[1] - forceItem.location[1];
        float f7 = (float)Math.sqrt(f5 * f5 + f6 * f6);
        boolean bl2 = false;
        if (f7 == 0.0f) {
            f5 = (this.rand.nextFloat() - 0.5f) / 50.0f;
            f6 = (this.rand.nextFloat() - 0.5f) / 50.0f;
            f7 = (float)Math.sqrt(f5 * f5 + f6 * f6);
            bl2 = true;
        }
        boolean bl3 = bl = this.params[1] > 0.0f && f7 > this.params[1];
        if (!quadTreeNode.hasChildren && quadTreeNode.value != forceItem || !bl2 && (f3 - f) / f7 < this.params[2]) {
            if (bl) {
                return;
            }
            float f8 = this.params[0] * forceItem.mass * quadTreeNode.mass / (f7 * f7 * f7);
            forceItem.force[0] = forceItem.force[0] + f8 * f5;
            forceItem.force[1] = forceItem.force[1] + f8 * f6;
        } else if (quadTreeNode.hasChildren) {
            float f9 = (f + f3) / 2.0f;
            float f10 = (f2 + f4) / 2.0f;
            for (int i = 0; i < quadTreeNode.children.length; ++i) {
                if (quadTreeNode.children[i] == null) continue;
                this.forceHelper(forceItem, quadTreeNode.children[i], i == 1 || i == 3 ? f9 : f, i > 1 ? f10 : f2, i == 1 || i == 3 ? f3 : f9, i > 1 ? f4 : f10);
            }
            if (bl) {
                return;
            }
            if (quadTreeNode.value != null && quadTreeNode.value != forceItem) {
                float f11 = this.params[0] * forceItem.mass * quadTreeNode.value.mass / (f7 * f7 * f7);
                forceItem.force[0] = forceItem.force[0] + f11 * f5;
                forceItem.force[1] = forceItem.force[1] + f11 * f6;
            }
        }
    }

    public static final class QuadTreeNodeFactory {
        private int maxNodes = 50000;
        private ArrayList nodes = new ArrayList();

        public QuadTreeNode getQuadTreeNode() {
            if (this.nodes.size() > 0) {
                return (QuadTreeNode)this.nodes.remove(this.nodes.size() - 1);
            }
            return new QuadTreeNode();
        }

        public void reclaim(QuadTreeNode quadTreeNode) {
            quadTreeNode.mass = 0.0f;
            quadTreeNode.com[0] = 0.0f;
            quadTreeNode.com[1] = 0.0f;
            quadTreeNode.value = null;
            quadTreeNode.hasChildren = false;
            Arrays.fill(quadTreeNode.children, null);
            if (this.nodes.size() < this.maxNodes) {
                this.nodes.add(quadTreeNode);
            }
        }
    }

    public static final class QuadTreeNode {
        boolean hasChildren = false;
        float mass;
        float[] com = new float[]{0.0f, 0.0f};
        ForceItem value;
        QuadTreeNode[] children = new QuadTreeNode[4];
    }
}

