/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScaleSelector
extends JComponent
implements ChangeListener {
    private static final int MAX_SIZE = 135;
    private ImagePanel preview;
    private JLabel value;
    private JLabel size;
    private JSlider slider = new JSlider(1, 10, 1);
    private Image image;
    private int width;
    private int height;

    public ScaleSelector() {
        this.value = new JLabel("x1");
        this.size = new JLabel("   ");
        this.preview = new ImagePanel();
        this.value.setPreferredSize(new Dimension(25, 10));
        this.size.setHorizontalAlignment(0);
        this.slider.setMajorTickSpacing(1);
        this.slider.setSnapToTicks(true);
        this.slider.addChangeListener(this);
        this.setLayout(new BorderLayout());
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(5));
        box.add(Box.createHorizontalGlue());
        box.add(this.preview);
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(5));
        this.add((Component)box, "Center");
        Box box2 = new Box(0);
        box2.add(this.slider);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.value);
        Box box3 = new Box(0);
        box3.add(Box.createHorizontalStrut(5));
        box3.add(Box.createHorizontalGlue());
        box3.add(this.size);
        box3.add(Box.createHorizontalGlue());
        box3.add(Box.createHorizontalStrut(5));
        Box box4 = new Box(1);
        box4.add(box2);
        box4.add(box3);
        this.add((Component)box4, "South");
    }

    public void setImage(Image image) {
        this.image = this.getScaledImage(image);
        this.stateChanged(null);
    }

    private Image getScaledImage(Image image) {
        int n = this.width = image.getWidth(null);
        int n2 = this.height = image.getHeight(null);
        double d = (double)n / (double)n2;
        int n3 = 135;
        int n4 = 135;
        if (n > n2) {
            n4 = (int)Math.round((double)n3 / d);
        } else {
            n3 = (int)Math.round((double)n4 * d);
        }
        return image.getScaledInstance(n3, n4, 4);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getValue();
        this.value.setText("x" + String.valueOf(n));
        this.size.setText("Image Size: " + this.width * n + " x " + this.height * n + " pixels");
        this.preview.repaint();
    }

    public double getScale() {
        return this.slider.getValue();
    }

    public class ImagePanel
    extends JComponent {
        Dimension d = new Dimension(135, 135);

        public ImagePanel() {
            this.setPreferredSize(this.d);
            this.setMinimumSize(this.d);
            this.setMaximumSize(this.d);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            double d = 0.4 + 0.06 * ScaleSelector.this.getScale();
            int n = (int)Math.round(d * (double)ScaleSelector.this.image.getWidth(null));
            int n2 = (int)Math.round(d * (double)ScaleSelector.this.image.getHeight(null));
            Image image = d == 1.0 ? ScaleSelector.this.image : ScaleSelector.this.image.getScaledInstance(n, n2, 1);
            int n3 = (135 - n) / 2;
            int n4 = (135 - n2) / 2;
            graphics.drawImage(image, n3, n4, null);
        }
    }
}

