/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import prefuse.util.collections.AbstractTreeMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.ObjectIntSortedMap;

public class ObjectIntTreeMap
extends AbstractTreeMap
implements ObjectIntSortedMap {
    private ObjectEntry dummy = new ObjectEntry(null, Integer.MIN_VALUE, NIL, 0);
    private Comparator cmp = null;

    public ObjectIntTreeMap() {
        this((Comparator)null, false);
    }

    public ObjectIntTreeMap(boolean bl) {
        this((Comparator)null, bl);
    }

    public ObjectIntTreeMap(Comparator comparator) {
        this(comparator, false);
    }

    public ObjectIntTreeMap(Comparator comparator, boolean bl) {
        super(null, bl);
        this.cmp = comparator == null ? super.comparator() : comparator;
    }

    @Override
    public Comparator comparator() {
        return this.cmp;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.find(object, 0) != NIL;
    }

    @Override
    public int get(Object object) {
        AbstractTreeMap.Entry entry = this.find(object, 0);
        return entry == NIL ? Integer.MIN_VALUE : entry.val;
    }

    @Override
    public int put(Object object, int n) {
        AbstractTreeMap.Entry entry = this.root;
        this.lastOrder = 0;
        if (entry == NIL) {
            this.incrementSize(true);
            this.root = new ObjectEntry(object, n, NIL, this.lastOrder);
            return Integer.MIN_VALUE;
        }
        this.dummy.key = object;
        this.dummy.order = Integer.MAX_VALUE;
        while (true) {
            int n2;
            if ((n2 = this.compare(this.dummy, entry)) == 0) {
                return entry.setValue(n);
            }
            if (n2 < 0) {
                if (entry.left != NIL) {
                    entry = entry.left;
                    continue;
                }
                this.incrementSize(this.lastOrder == 0);
                entry.left = new ObjectEntry(object, n, entry, this.lastOrder);
                this.fixUpInsert(entry.left);
                return Integer.MIN_VALUE;
            }
            if (entry.right == NIL) break;
            entry = entry.right;
        }
        this.incrementSize(this.lastOrder == 0);
        entry.right = new ObjectEntry(object, n, entry, this.lastOrder);
        this.fixUpInsert(entry.right);
        return Integer.MIN_VALUE;
    }

    @Override
    public int remove(Object object) {
        AbstractTreeMap.Entry entry = this.allowDuplicates ? this.findPredecessor(object, Integer.MAX_VALUE) : this.find(object, 0);
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        int n = entry.val;
        this.remove(entry);
        return n;
    }

    @Override
    public int remove(Object object, int n) {
        AbstractTreeMap.Entry entry = this.findCeiling(object, 0);
        if (entry != NIL && (object == null && entry.getKey() != null || object != null && !entry.getKey().equals(object))) {
            entry = this.successor(entry);
        }
        if (entry == NIL || object == null && entry.getKey() != null || object != null && !entry.getKey().equals(object)) {
            return Integer.MIN_VALUE;
        }
        while (entry.val != n && entry != NIL) {
            entry = this.successor(entry);
        }
        if (entry == NIL) {
            return Integer.MIN_VALUE;
        }
        this.remove(entry);
        return n;
    }

    @Override
    public Object firstKey() {
        return this.minimum(this.root).getKey();
    }

    @Override
    public Object lastKey() {
        return this.maximum(this.root).getKey();
    }

    @Override
    public Iterator keyIterator() {
        return new AbstractTreeMap.KeyIterator();
    }

    @Override
    public Iterator keyRangeIterator(Object object, boolean bl, Object object2, boolean bl2) {
        AbstractTreeMap.Entry entry;
        AbstractTreeMap.Entry entry2;
        boolean bl3;
        if (object == object2 && (object == MIN_KEY || object == MAX_KEY)) {
            return Collections.EMPTY_LIST.iterator();
        }
        boolean bl4 = object == MIN_KEY || object2 == MAX_KEY;
        boolean bl5 = bl3 = object == MAX_KEY || object2 == MIN_KEY;
        if (!bl3 && (bl4 || this.cmp.compare(object, object2) <= 0)) {
            entry2 = this.findCeiling(object, bl ? 0 : Integer.MAX_VALUE);
            entry = this.findCeiling(object2, bl2 ? Integer.MAX_VALUE : 0);
        } else {
            entry2 = this.findCeiling(object, bl ? Integer.MAX_VALUE : 0);
            entry2 = this.predecessor(entry2);
            entry = this.findCeiling(object2, bl2 ? 0 : Integer.MAX_VALUE);
            entry = this.predecessor(entry);
        }
        return new AbstractTreeMap.KeyIterator(entry2, entry);
    }

    @Override
    public IntIterator valueRangeIterator(Object object, boolean bl, Object object2, boolean bl2) {
        return new AbstractTreeMap.ValueIterator((AbstractTreeMap.EntryIterator)this.keyRangeIterator(object, bl, object2, bl2));
    }

    @Override
    protected int compare(AbstractTreeMap.Entry entry, AbstractTreeMap.Entry entry2) {
        Object object;
        Object object2 = entry.getKey();
        if (object2 == (object = entry2.getKey()) && (object2 == MIN_KEY || object2 == MAX_KEY)) {
            return 0;
        }
        if (object2 == MIN_KEY || object == MAX_KEY) {
            return -1;
        }
        if (object2 == MAX_KEY || object == MIN_KEY) {
            return 1;
        }
        int n = this.cmp.compare(entry.getKey(), entry2.getKey());
        if (this.allowDuplicates && n == 0) {
            n = entry.order < entry2.order ? -1 : (entry.order > entry2.order ? 1 : 0);
            this.lastOrder = 1 + (n < 0 ? entry.order : entry2.order);
        }
        return n;
    }

    private AbstractTreeMap.Entry find(Object object, int n) {
        this.dummy.key = object;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.find(this.dummy);
        this.dummy.key = null;
        return entry;
    }

    private AbstractTreeMap.Entry findPredecessor(Object object, int n) {
        this.dummy.key = object;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findPredecessor(this.dummy);
        this.dummy.key = null;
        return entry;
    }

    private AbstractTreeMap.Entry findCeiling(Object object, int n) {
        this.dummy.key = object;
        this.dummy.order = n;
        AbstractTreeMap.Entry entry = this.findCeiling(this.dummy);
        this.dummy.key = null;
        return entry;
    }

    static class ObjectEntry
    extends AbstractTreeMap.Entry {
        Object key;

        public ObjectEntry(Object object, int n) {
            super(n);
            this.key = object;
        }

        public ObjectEntry(Object object, int n, AbstractTreeMap.Entry entry, int n2) {
            super(n, entry, n2);
            this.key = object;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public void copyFields(AbstractTreeMap.Entry entry) {
            super.copyFields(entry);
            this.key = entry.getKey();
        }
    }
}

