/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import prefuse.util.collections.AbstractLiteralIterator;
import prefuse.util.collections.DefaultLiteralComparator;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LiteralComparator;

public abstract class AbstractTreeMap
implements IntSortedMap {
    protected static final boolean RED = false;
    protected static final boolean BLACK = true;
    protected static final Entry NIL;
    protected LiteralComparator cmp = null;
    protected Entry root = NIL;
    protected boolean allowDuplicates;
    protected int size = 0;
    protected int unique = 0;
    protected int modCount = 0;
    protected int lastOrder = 0;

    public AbstractTreeMap(LiteralComparator literalComparator, boolean bl) {
        this.cmp = literalComparator == null ? DefaultLiteralComparator.getInstance() : literalComparator;
        this.allowDuplicates = bl;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.root == NIL;
    }

    @Override
    public Comparator comparator() {
        return this.cmp;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        this.root = NIL;
    }

    @Override
    public int getMinimum() {
        return this.minimum(this.root).getValue();
    }

    @Override
    public int getMaximum() {
        return this.maximum(this.root).getValue();
    }

    @Override
    public int getMedian() {
        Entry entry = this.minimum(this.root);
        for (int i = 0; i < this.size / 2; ++i) {
            entry = this.successor(entry);
        }
        return entry.getValue();
    }

    @Override
    public int getUniqueCount() {
        return this.unique;
    }

    @Override
    public boolean containsValue(int n) {
        return this.root == NIL ? false : this.containsValue(this.root, n);
    }

    private boolean containsValue(Entry entry, int n) {
        if (entry.val == n) {
            return true;
        }
        return entry.left != NIL && this.containsValue(entry.left, n) || entry.right != NIL && this.containsValue(entry.right, n);
    }

    @Override
    public IntIterator valueIterator(boolean bl) {
        return new ValueIterator(new EntryIterator(!bl));
    }

    protected void incrementSize(boolean bl) {
        ++this.size;
        ++this.modCount;
        if (bl) {
            ++this.unique;
        }
    }

    protected void decrementSize(boolean bl) {
        --this.size;
        ++this.modCount;
        if (bl) {
            --this.unique;
        }
    }

    protected abstract int compare(Entry var1, Entry var2);

    protected Entry find(Entry entry) {
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            int n = this.compare(entry, entry2);
            if (n == 0) {
                return entry2;
            }
            if (n < 0) {
                entry2 = entry2.left;
                continue;
            }
            entry2 = entry2.right;
        }
        return entry2;
    }

    protected Entry findPredecessor(Entry entry) {
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            int n = this.compare(entry, entry2);
            if (n > 0) {
                if (entry2.right == NIL) {
                    return entry2;
                }
                entry2 = entry2.right;
                continue;
            }
            if (entry2.left != NIL) {
                entry2 = entry2.left;
                continue;
            }
            Entry entry3 = entry2.p;
            Entry entry4 = entry2;
            while (entry3 != NIL && entry4 == entry3.left) {
                entry4 = entry3;
                entry3 = entry3.p;
            }
            return entry3;
        }
        return entry2;
    }

    protected Entry findCeiling(Entry entry) {
        Entry entry2 = this.root;
        while (entry2 != NIL) {
            int n = this.compare(entry, entry2);
            if (n == 0) {
                return entry2;
            }
            if (n < 0) {
                if (entry2.left != NIL) {
                    entry2 = entry2.left;
                    continue;
                }
                return entry2;
            }
            if (entry2.right != NIL) {
                entry2 = entry2.right;
                continue;
            }
            Entry entry3 = entry2.p;
            Entry entry4 = entry2;
            while (entry3 != NIL && entry4 == entry3.right) {
                entry4 = entry3;
                entry3 = entry3.p;
            }
            return entry3;
        }
        return entry2;
    }

    protected Entry minimum(Entry entry) {
        while (entry.left != NIL) {
            entry = entry.left;
        }
        return entry;
    }

    protected Entry maximum(Entry entry) {
        while (entry.right != NIL) {
            entry = entry.right;
        }
        return entry;
    }

    protected Entry successor(Entry entry) {
        if (entry.right != NIL) {
            return this.minimum(entry.right);
        }
        Entry entry2 = entry.p;
        while (entry2 != NIL && entry == entry2.right) {
            entry = entry2;
            entry2 = entry2.p;
        }
        return entry2;
    }

    protected Entry predecessor(Entry entry) {
        if (entry.left != NIL) {
            return this.maximum(entry.left);
        }
        Entry entry2 = entry.p;
        while (entry2 != NIL && entry == entry2.left) {
            entry = entry2;
            entry2 = entry2.p;
        }
        return entry2;
    }

    protected void rotateLeft(Entry entry) {
        Entry entry2 = entry.right;
        entry.right = entry2.left;
        if (entry2.left != NIL) {
            entry2.left.p = entry;
        }
        entry2.p = entry.p;
        if (entry.p == NIL) {
            this.root = entry2;
        } else if (entry.p.left == entry) {
            entry.p.left = entry2;
        } else {
            entry.p.right = entry2;
        }
        entry2.left = entry;
        entry.p = entry2;
    }

    protected void rotateRight(Entry entry) {
        Entry entry2 = entry.left;
        entry.left = entry2.right;
        if (entry2.right != NIL) {
            entry2.right.p = entry;
        }
        entry2.p = entry.p;
        if (entry.p == NIL) {
            this.root = entry2;
        } else if (entry.p.right == entry) {
            entry.p.right = entry2;
        } else {
            entry.p.left = entry2;
        }
        entry2.right = entry;
        entry.p = entry2;
    }

    protected void fixUpInsert(Entry entry) {
        entry.color = false;
        while (entry != NIL && entry != this.root && !entry.p.color) {
            Entry entry2;
            if (entry.p == entry.p.p.left) {
                entry2 = entry.p.p.right;
                if (!entry2.color) {
                    entry.p.color = true;
                    entry2.color = true;
                    entry.p.p.color = false;
                    entry = entry.p.p;
                    continue;
                }
                if (entry == entry.p.right) {
                    entry = entry.p;
                    this.rotateLeft(entry);
                }
                entry.p.color = true;
                entry.p.p.color = false;
                if (entry.p.p == NIL) continue;
                this.rotateRight(entry.p.p);
                continue;
            }
            entry2 = entry.p.p.left;
            if (!entry2.color) {
                entry.p.color = true;
                entry2.color = true;
                entry.p.p.color = false;
                entry = entry.p.p;
                continue;
            }
            if (entry == entry.p.left) {
                entry = entry.p;
                this.rotateRight(entry);
            }
            entry.p.color = true;
            entry.p.p.color = false;
            if (entry.p.p == NIL) continue;
            this.rotateLeft(entry.p.p);
        }
        this.root.color = true;
    }

    protected void fixUpRemove(Entry entry) {
        while (entry != this.root && entry.color) {
            Entry entry2;
            if (entry == entry.p.left) {
                entry2 = entry.p.right;
                if (!entry2.color) {
                    entry2.color = true;
                    entry.p.color = false;
                    this.rotateLeft(entry.p);
                    entry2 = entry.p.right;
                }
                if (entry2.left.color && entry2.right.color) {
                    entry2.color = false;
                    entry = entry.p;
                    continue;
                }
                if (entry2.right.color) {
                    entry2.left.color = true;
                    entry2.color = false;
                    this.rotateRight(entry2);
                    entry2 = entry.p.right;
                }
                entry2.color = entry.p.color;
                entry.p.color = true;
                entry2.right.color = true;
                this.rotateLeft(entry.p);
                entry = this.root;
                continue;
            }
            entry2 = entry.p.left;
            if (!entry2.color) {
                entry2.color = true;
                entry.p.color = false;
                this.rotateRight(entry.p);
                entry2 = entry.p.left;
            }
            if (entry2.right.color && entry2.left.color) {
                entry2.color = false;
                entry = entry.p;
                continue;
            }
            if (entry2.left.color) {
                entry2.right.color = true;
                entry2.color = false;
                this.rotateLeft(entry2);
                entry2 = entry.p.left;
            }
            entry2.color = entry.p.color;
            entry.p.color = true;
            entry2.left.color = true;
            this.rotateRight(entry.p);
            entry = this.root;
        }
        entry.color = true;
    }

    protected void remove(Entry entry) {
        boolean bl = !entry.keyEquals(entry.left) && !entry.keyEquals(entry.right) && !entry.keyEquals(entry.p);
        Entry entry2 = entry.left != NIL && entry.right != NIL ? this.successor(entry) : entry;
        Entry entry3 = entry2.left != NIL ? entry2.left : entry2.right;
        entry3.p = entry2.p;
        if (entry2.p == NIL) {
            this.root = entry3;
        } else if (entry2 == entry2.p.left) {
            entry2.p.left = entry3;
        } else {
            entry2.p.right = entry3;
        }
        if (entry2 != entry) {
            entry.copyFields(entry2);
        }
        if (entry2.color) {
            this.fixUpRemove(entry3);
        }
        this.decrementSize(bl);
    }

    static {
        AbstractTreeMap.NIL.right = AbstractTreeMap.NIL.p = (NIL = new Entry(Integer.MIN_VALUE));
        AbstractTreeMap.NIL.left = AbstractTreeMap.NIL.p;
    }

    protected class ValueIterator
    extends IntIterator {
        EntryIterator m_iter;

        public ValueIterator(EntryIterator entryIterator) {
            this.m_iter = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public int nextInt() {
            return this.m_iter.nextEntry().val;
        }

        @Override
        public void remove() {
            this.m_iter.remove();
        }
    }

    protected class KeyIterator
    extends EntryIterator {
        public KeyIterator() {
            super(false);
        }

        public KeyIterator(Entry entry, Entry entry2) {
            super(entry, entry2);
        }

        @Override
        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    protected class EntryIterator
    extends AbstractLiteralIterator {
        private int expectedModCount;
        private Entry lastReturned;
        private boolean reverse;
        Entry next;
        Entry end;

        EntryIterator(boolean bl) {
            this.expectedModCount = AbstractTreeMap.this.modCount;
            this.lastReturned = NIL;
            this.reverse = false;
            this.next = bl ? AbstractTreeMap.this.maximum(AbstractTreeMap.this.root) : AbstractTreeMap.this.minimum(AbstractTreeMap.this.root);
            this.end = NIL;
        }

        EntryIterator(Entry entry, Entry entry2) {
            this.expectedModCount = AbstractTreeMap.this.modCount;
            this.lastReturned = NIL;
            this.reverse = false;
            this.next = entry;
            this.end = entry2;
            this.reverse = entry == NIL ? true : (entry2 == NIL ? false : AbstractTreeMap.this.compare(entry, entry2) > 0);
        }

        @Override
        public boolean hasNext() {
            return this.next != this.end;
        }

        final Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (AbstractTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.lastReturned = this.next;
            Entry entry = this.next = this.reverse ? AbstractTreeMap.this.predecessor(this.next) : AbstractTreeMap.this.successor(this.next);
            if (this.lastReturned == NIL) {
                System.err.println("Encountered NIL in iteration!");
            }
            return this.lastReturned;
        }

        public Object next() {
            return this.nextEntry();
        }

        @Override
        public void remove() {
            if (this.lastReturned == NIL) {
                throw new IllegalStateException();
            }
            if (AbstractTreeMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned.left != NIL && this.lastReturned.right != NIL) {
                this.next = this.lastReturned;
            }
            AbstractTreeMap.this.remove(this.lastReturned);
            ++this.expectedModCount;
            this.lastReturned = NIL;
        }
    }

    public static class Entry {
        int val;
        int order;
        Entry left = null;
        Entry right = null;
        Entry p;
        boolean color = true;

        public Entry(int n) {
            this.val = n;
        }

        public Entry(int n, Entry entry, int n2) {
            this.val = n;
            this.p = entry;
            this.order = n2;
            this.left = NIL;
            this.right = NIL;
        }

        public int getIntKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public long getLongKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public float getFloatKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public double getDoubleKey() {
            throw new UnsupportedOperationException("Unsupported");
        }

        public Object getKey() {
            return null;
        }

        public int getValue() {
            return this.val;
        }

        public int getOrder() {
            return this.order;
        }

        public int setValue(int n) {
            int n2 = this.val;
            this.val = n;
            return n2;
        }

        public boolean keyEquals(Entry entry) {
            Object object = this.getKey();
            return object == null ? object == entry.getKey() : object.equals(entry.getKey());
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.val == entry.val && this.getKey() == entry.getKey();
        }

        public int hashCode() {
            int n = this.getKey().hashCode();
            int n2 = this.val;
            return n ^ n2;
        }

        public String toString() {
            return this.getKey() + "=" + this.val;
        }

        public void copyFields(Entry entry) {
            this.val = entry.val;
            this.order = entry.order;
        }
    }
}

