/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.data.Schema;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.PrefuseConfig;
import prefuse.util.StringLib;
import prefuse.visual.VisualItem;

public class PrefuseLib {
    private static final String GROUP_DELIMITER = PrefuseConfig.get("data.delimiter");
    private static final double SIZE_SCALE_FACTOR = PrefuseConfig.getDouble("size.scale2D");
    public static final String FIELD_PREFIX = PrefuseConfig.get("data.visual.fieldPrefix");

    private PrefuseLib() {
    }

    public static String getMemoryUsageInKB() {
        long l = Runtime.getRuntime().totalMemory() / 2048L;
        long l2 = Runtime.getRuntime().freeMemory() / 2048L;
        long l3 = Runtime.getRuntime().maxMemory() / 2048L;
        return "Memory: " + (l - l2) + "k / " + l + "k / " + l3 + "k";
    }

    public static String getMemoryUsageInMB() {
        long l = Runtime.getRuntime().totalMemory() / 0x200000L;
        long l2 = Runtime.getRuntime().freeMemory() / 0x200000L;
        long l3 = Runtime.getRuntime().maxMemory() / 0x200000L;
        return "Memory: " + (l - l2) + "M / " + l + "M / " + l3 + "M";
    }

    public static String getDisplayStats(Display display) {
        float f = (float)Math.round(display.getFrameRate() * 100.0) / 100.0f;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() / 0x200000L;
        long l2 = runtime.freeMemory() / 0x200000L;
        long l3 = runtime.maxMemory() / 0x200000L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("frame rate: ").append(f).append("fps - ");
        stringBuffer.append(display.getVisibleItemCount()).append(" items - ");
        stringBuffer.append("fonts(").append(FontLib.getCacheMissCount());
        stringBuffer.append(") colors(");
        stringBuffer.append(ColorLib.getCacheMissCount()).append(')');
        stringBuffer.append(" mem(");
        stringBuffer.append(l - l2).append("M / ");
        stringBuffer.append(l3).append("M)");
        stringBuffer.append(" (x:");
        stringBuffer.append(StringLib.formatNumber(display.getDisplayX(), 2));
        stringBuffer.append(", y:");
        stringBuffer.append(StringLib.formatNumber(display.getDisplayY(), 2));
        stringBuffer.append(", z:");
        stringBuffer.append(StringLib.formatNumber(display.getScale(), 5)).append(")");
        return stringBuffer.toString();
    }

    public static double getSize2D(double d) {
        return Math.pow(d, SIZE_SCALE_FACTOR);
    }

    public static double distance(VisualItem visualItem, VisualItem visualItem2) {
        double d = visualItem.getX() - visualItem2.getX();
        double d2 = visualItem.getY() - visualItem2.getY();
        return Math.sqrt(d * d + d2 * d2);
    }

    public static void update(VisualItem visualItem, String string, Object object) {
        visualItem.set(PrefuseLib.getStartField(string), visualItem.get(string));
        visualItem.set(string, object);
        visualItem.set(PrefuseLib.getEndField(string), object);
    }

    public static void updateInt(VisualItem visualItem, String string, int n) {
        visualItem.setInt(PrefuseLib.getStartField(string), visualItem.getInt(string));
        visualItem.setInt(string, n);
        visualItem.setInt(PrefuseLib.getEndField(string), n);
    }

    public static void updateLong(VisualItem visualItem, String string, long l) {
        visualItem.setLong(PrefuseLib.getStartField(string), visualItem.getLong(string));
        visualItem.setLong(string, l);
        visualItem.setLong(PrefuseLib.getEndField(string), l);
    }

    public static void updateFloat(VisualItem visualItem, String string, float f) {
        visualItem.setFloat(PrefuseLib.getStartField(string), visualItem.getFloat(string));
        visualItem.setFloat(string, f);
        visualItem.setFloat(PrefuseLib.getEndField(string), f);
    }

    public static void updateDouble(VisualItem visualItem, String string, double d) {
        visualItem.setDouble(PrefuseLib.getStartField(string), visualItem.getDouble(string));
        visualItem.setDouble(string, d);
        visualItem.setDouble(PrefuseLib.getEndField(string), d);
    }

    public static void updateBoolean(VisualItem visualItem, String string, boolean bl) {
        visualItem.setBoolean(PrefuseLib.getStartField(string), visualItem.getBoolean(string));
        visualItem.setBoolean(string, bl);
        visualItem.setBoolean(PrefuseLib.getEndField(string), bl);
    }

    public static void updateVisible(VisualItem visualItem, boolean bl) {
        visualItem.setStartVisible(visualItem.isVisible());
        visualItem.setVisible(bl);
        visualItem.setEndVisible(bl);
    }

    public static void setX(VisualItem visualItem, VisualItem visualItem2, double d) {
        double d2 = visualItem.getX();
        if (Double.isNaN(d2)) {
            d2 = visualItem2 != null ? visualItem2.getX() : d;
        }
        visualItem.setStartX(d2);
        visualItem.setEndX(d);
        visualItem.setX(d);
    }

    public static void setY(VisualItem visualItem, VisualItem visualItem2, double d) {
        double d2 = visualItem.getY();
        if (Double.isNaN(d2)) {
            d2 = visualItem2 != null ? visualItem2.getY() : d;
        }
        visualItem.setStartY(d2);
        visualItem.setEndY(d);
        visualItem.setY(d);
    }

    public static boolean isChildGroup(String string) {
        return string.indexOf(GROUP_DELIMITER) != -1;
    }

    public static String getParentGroup(String string) {
        int n = string.lastIndexOf(GROUP_DELIMITER);
        return n < 0 ? null : string.substring(0, n);
    }

    public static String getChildGroup(String string) {
        int n = string.lastIndexOf(GROUP_DELIMITER);
        return n < 0 ? null : string.substring(n + 1);
    }

    public static String getGroupName(String string, String string2) {
        return string + GROUP_DELIMITER + string2;
    }

    public static String getStartField(String string) {
        return string + ":start";
    }

    public static String getEndField(String string) {
        return string + ":end";
    }

    public static Schema getVisualItemSchema() {
        Schema schema = new Schema();
        schema.addColumn(VisualItem.VALIDATED, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.VISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.STARTVISIBLE, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.ENDVISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.INTERACTIVE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.EXPANDED, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.FIXED, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.HIGHLIGHT, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.HOVER, Boolean.TYPE, Boolean.FALSE);
        schema.addInterpolatedColumn(VisualItem.X, Double.TYPE);
        schema.addInterpolatedColumn(VisualItem.Y, Double.TYPE);
        schema.addColumn(VisualItem.BOUNDS, Rectangle2D.class, new Rectangle2D.Double());
        Integer n = new Integer(ColorLib.rgba(0, 0, 0, 0));
        schema.addInterpolatedColumn(VisualItem.STROKECOLOR, Integer.TYPE, n);
        Integer n2 = new Integer(ColorLib.rgba(0, 0, 0, 0));
        schema.addInterpolatedColumn(VisualItem.FILLCOLOR, Integer.TYPE, n2);
        Integer n3 = new Integer(ColorLib.rgba(0, 0, 0, 0));
        schema.addInterpolatedColumn(VisualItem.TEXTCOLOR, Integer.TYPE, n3);
        schema.addInterpolatedColumn(VisualItem.SIZE, Double.TYPE, new Double(1.0));
        schema.addColumn(VisualItem.SHAPE, Integer.TYPE, new Integer(0));
        schema.addColumn(VisualItem.STROKE, Stroke.class, new BasicStroke());
        Font font = FontLib.getFont("SansSerif", 0, 10);
        schema.addInterpolatedColumn(VisualItem.FONT, Font.class, font);
        schema.addColumn(VisualItem.DOI, Double.TYPE, new Double(Double.MIN_VALUE));
        return schema;
    }

    public static Schema getMinimalVisualSchema() {
        Schema schema = new Schema();
        schema.addColumn(VisualItem.VALIDATED, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.VISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.STARTVISIBLE, Boolean.TYPE, Boolean.FALSE);
        schema.addColumn(VisualItem.ENDVISIBLE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.INTERACTIVE, Boolean.TYPE, Boolean.TRUE);
        schema.addColumn(VisualItem.BOUNDS, Rectangle2D.class, new Rectangle2D.Double());
        return schema;
    }

    public static Schema getAxisLabelSchema() {
        Schema schema = PrefuseLib.getVisualItemSchema();
        schema.setDefault(VisualItem.STARTVISIBLE, (Object)Boolean.FALSE);
        Integer n = new Integer(ColorLib.gray(230));
        schema.setInterpolatedDefault(VisualItem.STROKECOLOR, n);
        n = new Integer(ColorLib.gray(150));
        schema.setInterpolatedDefault(VisualItem.TEXTCOLOR, n);
        Double d = new Double(Double.NaN);
        schema.addInterpolatedColumn(VisualItem.X2, Double.TYPE);
        schema.addInterpolatedColumn(VisualItem.Y2, Double.TYPE);
        schema.addColumn(VisualItem.LABEL, String.class);
        schema.addColumn(VisualItem.VALUE, Double.TYPE, d);
        return schema;
    }
}

