/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.util.Iterator;
import java.util.StringTokenizer;
import prefuse.data.Tuple;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.search.Trie;

public class PrefixSearchTupleSet
extends SearchTupleSet {
    private Trie m_trie;
    private Trie.TrieNode m_curNode;
    private String m_delim = " \t\n\r";
    private String m_query = "";

    public PrefixSearchTupleSet() {
        this(false);
    }

    public PrefixSearchTupleSet(boolean bl) {
        this.m_trie = new Trie(bl);
    }

    public String getDelimiterString() {
        return this.m_delim;
    }

    public void setDelimiterString(String string) {
        this.m_delim = string;
    }

    @Override
    public String getQuery() {
        return this.m_query;
    }

    @Override
    public void search(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.m_query)) {
            return;
        }
        Tuple[] tupleArray = this.clearInternal();
        this.m_query = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_query, this.m_delim);
        if (!stringTokenizer.hasMoreTokens()) {
            this.m_query = "";
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.prefixSearch(stringTokenizer.nextToken());
        }
        Tuple[] tupleArray2 = this.getTupleCount() > 0 ? this.toArray() : null;
        this.fireTupleEvent(tupleArray2, tupleArray);
    }

    private void prefixSearch(String string) {
        this.m_curNode = this.m_trie.find(string);
        if (this.m_curNode != null) {
            Iterator iterator = this.trieIterator();
            while (iterator.hasNext()) {
                this.addInternal((Tuple)iterator.next());
            }
        }
    }

    @Override
    public void index(Tuple tuple, String string) {
        String string2 = tuple.getString(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.m_delim);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.addString(string3, tuple);
        }
    }

    private void addString(String string, Tuple tuple) {
        this.m_trie.addString(string, tuple);
    }

    @Override
    public boolean isUnindexSupported() {
        return true;
    }

    @Override
    public void unindex(Tuple tuple, String string) {
        String string2 = tuple.getString(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.m_delim);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.removeString(string3, tuple);
        }
    }

    @Override
    public void clear() {
        this.m_trie = new Trie(this.m_trie.isCaseSensitive());
        super.clear();
    }

    private void removeString(String string, Tuple tuple) {
        this.m_trie.removeString(string, tuple);
    }

    private Iterator trieIterator() {
        Trie trie = this.m_trie;
        trie.getClass();
        return new Trie.TrieIterator(trie, this.m_curNode);
    }
}

