/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prefuse.data.Table;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.ComparisonPredicate;
import prefuse.data.expression.Literal;
import prefuse.data.expression.OrPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.query.DynamicQueryBinding;
import prefuse.data.query.ListModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.ui.JToggleGroup;

public class ListQueryBinding
extends DynamicQueryBinding {
    private static final String ALL = "All";
    private Class m_type;
    private ListModel m_model;
    private Listener m_lstnr;
    private boolean m_includeAll;

    public ListQueryBinding(TupleSet tupleSet, String string) {
        this(tupleSet, string, true);
    }

    public ListQueryBinding(TupleSet tupleSet, String string, boolean bl) {
        super(tupleSet, string);
        this.m_type = DataLib.inferType(tupleSet, string);
        this.m_lstnr = new Listener();
        this.m_includeAll = bl;
        this.initPredicate();
        this.initModel();
    }

    private void initPredicate() {
        OrPredicate orPredicate = new OrPredicate();
        orPredicate.add(BooleanLiteral.TRUE);
        this.setPredicate(orPredicate);
    }

    private void initModel() {
        if (this.m_model != null) {
            this.m_model.removeListSelectionListener(this.m_lstnr);
        }
        Object[] objectArray = null;
        if (this.m_tuples instanceof Table) {
            ColumnMetadata columnMetadata = ((Table)this.m_tuples).getMetadata(this.m_field);
            objectArray = columnMetadata.getOrdinalArray();
        } else {
            objectArray = DataLib.ordinalArray(this.m_tuples.tuples(), this.m_field);
        }
        this.m_model = new ListModel(objectArray);
        this.m_model.addListSelectionListener(this.m_lstnr);
        if (this.m_includeAll) {
            this.m_model.insertElementAt(ALL, 0);
            this.m_model.setSelectedItem(ALL);
        }
    }

    public ListModel getListModel() {
        return this.m_model;
    }

    @Override
    public JComponent createComponent() {
        return this.createCheckboxGroup();
    }

    public JList createList() {
        JList jList = new JList(this.m_model);
        jList.setSelectionModel(this.m_model);
        return jList;
    }

    public JComboBox createComboBox() {
        return new JComboBox(this.m_model);
    }

    public JToggleGroup createCheckboxGroup() {
        return this.createToggleGroup(0);
    }

    public JToggleGroup createRadioGroup() {
        return this.createToggleGroup(1);
    }

    private JToggleGroup createToggleGroup(int n) {
        return new JToggleGroup(n, this.m_model, this.m_model);
    }

    private ComparisonPredicate getComparison(Object object) {
        ColumnExpression columnExpression = new ColumnExpression(this.m_field);
        Literal literal = Literal.getLiteral(object, this.m_type);
        return new ComparisonPredicate(2, columnExpression, literal);
    }

    private class Listener
    implements ListSelectionListener {
        private Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListModel listModel = (ListModel)listSelectionEvent.getSource();
            OrPredicate orPredicate = (OrPredicate)ListQueryBinding.this.m_query;
            if (listModel.isSelectionEmpty()) {
                orPredicate.clear();
            } else if (ListQueryBinding.this.m_includeAll && listModel.isSelectedIndex(0)) {
                orPredicate.set(BooleanLiteral.TRUE);
            } else {
                int n = listModel.getMinSelectionIndex();
                int n2 = listModel.getMaxSelectionIndex();
                int n3 = 0;
                for (int i = n; i <= n2; ++i) {
                    if (!listModel.isSelectedIndex(i)) continue;
                    ++n3;
                }
                if (n3 == listModel.getSize()) {
                    orPredicate.set(BooleanLiteral.TRUE);
                } else if (n3 == 1) {
                    orPredicate.set(ListQueryBinding.this.getComparison(listModel.getElementAt(n)));
                } else {
                    Predicate[] predicateArray = new Predicate[n3];
                    int n4 = 0;
                    for (int i = n; i <= n2; ++i) {
                        if (!listModel.isSelectedIndex(i)) continue;
                        predicateArray[n4++] = ListQueryBinding.this.getComparison(listModel.getElementAt(i));
                    }
                    orPredicate.set(predicateArray);
                }
            }
        }
    }
}

