/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.StringTokenizer;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class IntArrayParser
implements DataParser {
    @Override
    public Class getType() {
        return int[].class;
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof int[])) {
            throw new IllegalArgumentException("This class can only format Objects of type int[].");
        }
        int[] nArray = (int[])object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public boolean canParse(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            while (stringTokenizer.hasMoreTokens()) {
                Integer.parseInt(stringTokenizer.nextToken());
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Object parse(String string) throws DataParseException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                nArray[n] = Integer.parseInt(string2);
                ++n;
            }
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

