/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import java.util.StringTokenizer;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class FloatArrayParser
implements DataParser {
    @Override
    public Class getType() {
        return float[].class;
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof float[])) {
            throw new IllegalArgumentException("This class can only format Objects of type float[].");
        }
        float[] fArray = (float[])object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(fArray[i]).append('f');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public boolean canParse(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            while (stringTokenizer.hasMoreTokens()) {
                Float.parseFloat(stringTokenizer.nextToken());
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Object parse(String string) throws DataParseException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"[](){}, ");
            float[] fArray = new float[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                fArray[n] = Float.parseFloat(string2);
                ++n;
            }
            return fArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

