/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.util.ColorLib;

public class ColorIntParser
implements DataParser {
    @Override
    public Class getType() {
        return Integer.TYPE;
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)object).intValue());
    }

    @Override
    public boolean canParse(String string) {
        try {
            if (string.charAt(0) != '#') {
                return false;
            }
            ColorIntParser.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Object parse(String string) throws DataParseException {
        return new Integer(ColorIntParser.parseInt(string));
    }

    public static int parseInt(String string) throws DataParseException {
        try {
            return ColorLib.hex(string);
        }
        catch (Exception exception) {
            throw new DataParseException(exception);
        }
    }
}

