/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.io.DataIOException;
import prefuse.data.io.sql.DataSourceWorker;
import prefuse.data.io.sql.SQLDataHandler;
import prefuse.data.util.Index;

public class DatabaseDataSource {
    private static final Logger s_logger = Logger.getLogger(DatabaseDataSource.class.getName());
    protected Connection m_conn;
    protected Statement m_stmt;
    protected SQLDataHandler m_handler;

    DatabaseDataSource(Connection connection, SQLDataHandler sQLDataHandler) {
        this.m_conn = connection;
        this.m_handler = sQLDataHandler;
    }

    public synchronized Table getData(String string) throws DataIOException {
        return this.getData(null, string, null);
    }

    public synchronized Table getData(String string, String string2) throws DataIOException {
        return this.getData(null, string, string2);
    }

    public synchronized Table getData(Table table, String string) throws DataIOException {
        return this.getData(table, string, null);
    }

    public synchronized Table getData(Table table, String string, String string2) throws DataIOException {
        return this.getData(table, string, string2, null);
    }

    public synchronized Table getData(Table table, String string, String string2, Object object) throws DataIOException {
        ResultSet resultSet;
        try {
            resultSet = this.executeQuery(string);
        }
        catch (SQLException sQLException) {
            throw new DataIOException(sQLException);
        }
        return this.process(table, resultSet, string2, object);
    }

    public void loadData(Table table, String string) {
        this.loadData(table, string, null, null, null);
    }

    public void loadData(Table table, String string, String string2) {
        this.loadData(table, string, string2, null, null);
    }

    public void loadData(Table table, String string, Object object) {
        this.loadData(table, string, null, object, null);
    }

    public void loadData(Table table, String string, String string2, Object object) {
        this.loadData(table, string, string2, object, null);
    }

    public void loadData(Table table, String string, String string2, Object object, DataSourceWorker.Listener listener) {
        DataSourceWorker.Entry entry = new DataSourceWorker.Entry(this, table, string, string2, object, listener);
        DataSourceWorker.submit(entry);
    }

    private ResultSet executeQuery(String string) throws SQLException {
        if (this.m_stmt == null) {
            this.m_stmt = this.m_conn.createStatement();
        }
        long l = System.currentTimeMillis();
        s_logger.info("Issuing query: " + string);
        ResultSet resultSet = this.m_stmt.executeQuery(string);
        long l2 = System.currentTimeMillis() - l;
        s_logger.info("External query processing completed: " + l2 / 1000L + "." + l2 % 1000L + " seconds.");
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Table process(Table table, ResultSet resultSet, String string, Object object) throws DataIOException {
        int n = 0;
        long l = System.currentTimeMillis();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            if (table == null) {
                table = this.getSchema(resultSetMetaData, this.m_handler).instantiate();
                if (string != null) {
                    try {
                        table.index(string);
                        s_logger.info("Indexed field: " + string);
                    }
                    catch (Exception exception) {
                        s_logger.warning("Error indexing field: " + string);
                    }
                }
            }
            Object object2 = object = object == null ? table : object;
            while (resultSet.next()) {
                Object object3 = object;
                synchronized (object3) {
                    int n3 = this.getExistingRow(table, resultSet, string);
                    if (n3 < 0) {
                        n3 = table.addRow();
                    }
                    for (int i = 1; i <= n2; ++i) {
                        this.m_handler.process(table, n3, resultSet, i);
                    }
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            throw new DataIOException(sQLException);
        }
        long l2 = System.currentTimeMillis() - l;
        s_logger.info("Internal query processing completed: " + n + " rows, " + l2 / 1000L + "." + l2 % 1000L + " seconds.");
        return table;
    }

    protected int getExistingRow(Table table, ResultSet resultSet, String string) throws SQLException {
        if (string == null) {
            return -1;
        }
        Class clazz = table.getColumnType(string);
        if (clazz == null) {
            return -1;
        }
        Index index = table.index(string);
        if (clazz == Integer.TYPE) {
            return index.get(resultSet.getInt(string));
        }
        if (clazz == Long.TYPE) {
            return index.get(resultSet.getLong(string));
        }
        if (clazz == Float.TYPE) {
            return index.get(resultSet.getFloat(string));
        }
        if (clazz == Double.TYPE) {
            return index.get(resultSet.getDouble(string));
        }
        if (!clazz.isPrimitive()) {
            return index.get(resultSet.getObject(string));
        }
        return -1;
    }

    public Schema getSchema(ResultSetMetaData resultSetMetaData, SQLDataHandler sQLDataHandler) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        Schema schema = new Schema(n);
        for (int i = 1; i <= n; ++i) {
            int n2;
            String string = resultSetMetaData.getColumnName(i);
            Class clazz = sQLDataHandler.getDataType(string, n2 = resultSetMetaData.getColumnType(i));
            if (clazz == null) continue;
            schema.addColumn(string, clazz);
        }
        return schema;
    }
}

