/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.util.logging.Logger;
import prefuse.data.Table;
import prefuse.data.io.DataIOException;
import prefuse.data.io.sql.DatabaseDataSource;
import prefuse.util.PrefuseConfig;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;

public class DataSourceWorker
extends Thread {
    private static Logger s_logger = Logger.getLogger(DataSourceWorker.class.getName());
    private static DataSourceWorker s_instance;
    private static CopyOnWriteArrayList s_queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void submit(Entry entry) {
        if (s_queue == null) {
            s_queue = new CopyOnWriteArrayList();
        }
        if (s_instance == null) {
            s_instance = new DataSourceWorker();
        }
        s_queue.add(entry);
        DataSourceWorker dataSourceWorker = s_instance;
        synchronized (dataSourceWorker) {
            s_instance.notify();
        }
    }

    private DataSourceWorker() {
        super("prefuse_DatabaseWorker");
        int n = PrefuseConfig.getInt("data.io.worker.threadPriority");
        if (n >= 1 && n <= 10) {
            this.setPriority(n);
        }
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Entry entry = null;
            Object object = s_queue;
            synchronized (object) {
                if (s_queue.size() > 0) {
                    entry = (Entry)s_queue.remove(0);
                }
            }
            if (entry != null) {
                try {
                    if (entry.listener != null) {
                        entry.listener.preQuery(entry);
                    }
                    entry.ds.getData(entry.table, entry.query, entry.keyField, entry.lock);
                    if (entry.listener == null) continue;
                    entry.listener.postQuery(entry);
                }
                catch (DataIOException dataIOException) {
                    s_logger.warning(dataIOException.getMessage() + "\n" + StringLib.getStackTrace(dataIOException));
                }
                continue;
            }
            try {
                object = this;
                synchronized (object) {
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static interface Listener {
        public void preQuery(Entry var1);

        public void postQuery(Entry var1);
    }

    public static class Entry {
        DatabaseDataSource ds;
        Listener listener;
        Table table;
        String query;
        String keyField;
        Object lock;

        public Entry(DatabaseDataSource databaseDataSource, Table table, String string, String string2, Object object, Listener listener) {
            this.ds = databaseDataSource;
            this.table = table;
            this.query = string;
            this.keyField = string2;
            this.lock = object;
            this.listener = listener;
        }
    }
}

