/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TableReadListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;
import prefuse.data.parser.TypeInferencer;
import prefuse.util.collections.ByteArrayList;
import prefuse.util.io.IOLib;

public abstract class AbstractTextTableReader
extends AbstractTableReader {
    private ParserFactory m_pfactory;
    private boolean m_hasHeader;

    public AbstractTextTableReader() {
        this(ParserFactory.getDefaultFactory());
    }

    public AbstractTextTableReader(ParserFactory parserFactory) {
        this.m_pfactory = parserFactory;
        this.m_hasHeader = true;
    }

    public void setHasHeader(boolean bl) {
        this.m_hasHeader = bl;
    }

    @Override
    public Table readTable(InputStream inputStream) throws DataIOException {
        ByteArrayList byteArrayList = null;
        if (inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
        } else {
            try {
                byteArrayList = IOLib.readAsBytes(inputStream);
            }
            catch (IOException iOException) {
                throw new DataIOException(iOException);
            }
            inputStream = byteArrayList.getAsInputStream();
        }
        final TypeInferencer typeInferencer = new TypeInferencer(this.m_pfactory);
        final ArrayList arrayList = this.getColumnNames();
        final int[] nArray = new int[]{0, 0};
        TableReadListener tableReadListener = new TableReadListener(){
            int prevLine = -1;

            @Override
            public void readValue(int n, int n2, String string) throws DataParseException {
                if (n > 1 || !AbstractTextTableReader.this.m_hasHeader) {
                    typeInferencer.sample(n2 - 1, string);
                    if (n != this.prevLine) {
                        this.prevLine = n;
                        nArray[0] = nArray[0] + 1;
                    }
                } else if (n == 1 && AbstractTextTableReader.this.m_hasHeader) {
                    arrayList.add(string);
                }
                if (n2 > nArray[1]) {
                    nArray[1] = n2;
                }
            }
        };
        try {
            this.read(inputStream, tableReadListener);
        }
        catch (IOException iOException) {
            throw new DataIOException(iOException);
        }
        catch (DataParseException dataParseException) {
            // empty catch block
        }
        int n = nArray[0];
        int n2 = nArray[1];
        final Table table = new Table(n, n2);
        for (int i = 0; i < n2; ++i) {
            String string = this.m_hasHeader || i < arrayList.size() ? (String)arrayList.get(i) : AbstractTextTableReader.getDefaultHeader(i);
            table.addColumn(string, typeInferencer.getType(i));
            table.getColumn(i).setParser(typeInferencer.getParser(i));
        }
        nArray[1] = -1;
        nArray[0] = -1;
        TableReadListener tableReadListener2 = new TableReadListener(){
            int prevLine = -1;

            @Override
            public void readValue(int n, int n2, String string) throws DataParseException {
                if (n == 1 && AbstractTextTableReader.this.m_hasHeader) {
                    return;
                }
                if (n != this.prevLine) {
                    this.prevLine = n;
                    nArray[0] = nArray[0] + 1;
                }
                nArray[1] = n2 - 1;
                DataParser dataParser = typeInferencer.getParser(nArray[1]);
                table.set(nArray[0], nArray[1], dataParser.parse(string));
            }
        };
        try {
            if (inputStream.markSupported()) {
                inputStream.reset();
            } else {
                inputStream = byteArrayList.getAsInputStream();
            }
            this.read(inputStream, tableReadListener2);
        }
        catch (IOException iOException) {
            throw new DataIOException(iOException);
        }
        catch (DataParseException dataParseException) {
            throw new DataIOException("Parse exception for column \"" + nArray[1] + '\"' + " at row: " + nArray[0], dataParseException);
        }
        return table;
    }

    protected ArrayList getColumnNames() {
        return new ArrayList();
    }

    public static String getDefaultHeader(int n) {
        if (n == 0) {
            return "A";
        }
        int n2 = (int)(Math.log(n) / Math.log(26.0)) + 1;
        char[] cArray = new char[n2];
        int n3 = n2;
        cArray[--n3] = (char)(65 + n % 26);
        n /= 26;
        while (n > 26) {
            cArray[--n3] = (char)(65 + n % 26);
            n /= 26;
        }
        if (n > 0) {
            cArray[--n3] = (char)(65 + (n - 1) % 26);
        }
        return new String(cArray, n3, n2);
    }

    protected abstract void read(InputStream var1, TableReadListener var2) throws IOException, DataParseException;
}

