/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import prefuse.data.Table;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TableReader;
import prefuse.util.io.IOLib;

public abstract class AbstractTableReader
implements TableReader {
    @Override
    public Table readTable(String string) throws DataIOException {
        try {
            InputStream inputStream = IOLib.streamFromString(string);
            if (inputStream == null) {
                throw new DataIOException("Couldn't find " + string + ". Not a valid file, URL, or resource locator.");
            }
            return this.readTable(inputStream);
        }
        catch (IOException iOException) {
            throw new DataIOException(iOException);
        }
    }

    @Override
    public Table readTable(URL uRL) throws DataIOException {
        try {
            return this.readTable(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new DataIOException(iOException);
        }
    }

    @Override
    public Table readTable(File file) throws DataIOException {
        try {
            return this.readTable(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DataIOException(fileNotFoundException);
        }
    }
}

