/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Literal;
import prefuse.util.TypeLib;

public class NumericLiteral
extends Literal {
    private final Number m_number;
    private final Class m_type;

    public NumericLiteral(int n) {
        this.m_number = new Integer(n);
        this.m_type = Integer.TYPE;
    }

    public NumericLiteral(long l) {
        this.m_number = new Long(l);
        this.m_type = Long.TYPE;
    }

    public NumericLiteral(float f) {
        this.m_number = new Float(f);
        this.m_type = Float.TYPE;
    }

    public NumericLiteral(double d) {
        this.m_number = new Double(d);
        this.m_type = Double.TYPE;
    }

    public NumericLiteral(Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Invalid type!");
        }
        this.m_number = (Number)object;
        this.m_type = TypeLib.getPrimitiveType(this.m_number.getClass());
    }

    @Override
    public Class getType(Schema schema) {
        return this.m_type;
    }

    @Override
    public Object get(Tuple tuple) {
        return this.m_number;
    }

    @Override
    public int getInt(Tuple tuple) {
        return this.m_number.intValue();
    }

    @Override
    public long getLong(Tuple tuple) {
        return this.m_number.longValue();
    }

    @Override
    public float getFloat(Tuple tuple) {
        return this.m_number.floatValue();
    }

    @Override
    public double getDouble(Tuple tuple) {
        return this.m_number.doubleValue();
    }

    public String toString() {
        return this.m_number.toString();
    }
}

