/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.HashMap;
import prefuse.data.expression.AbsFunction;
import prefuse.data.expression.AcosFunction;
import prefuse.data.expression.AsinFunction;
import prefuse.data.expression.Atan2Function;
import prefuse.data.expression.AtanFunction;
import prefuse.data.expression.CapFunction;
import prefuse.data.expression.CeilFunction;
import prefuse.data.expression.ChildCountFunction;
import prefuse.data.expression.ColorInterpFunction;
import prefuse.data.expression.ConcatFunction;
import prefuse.data.expression.ConcatWsFunction;
import prefuse.data.expression.CosFunction;
import prefuse.data.expression.CotFunction;
import prefuse.data.expression.DegreeFunction;
import prefuse.data.expression.DegreesFunction;
import prefuse.data.expression.EFunction;
import prefuse.data.expression.ExpFunction;
import prefuse.data.expression.FloorFunction;
import prefuse.data.expression.FormatFunction;
import prefuse.data.expression.Function;
import prefuse.data.expression.GrayFunction;
import prefuse.data.expression.HSBAFunction;
import prefuse.data.expression.HSBFunction;
import prefuse.data.expression.HexFunction;
import prefuse.data.expression.InDegreeFunction;
import prefuse.data.expression.IsEdgeFunction;
import prefuse.data.expression.IsNodeFunction;
import prefuse.data.expression.LPadFunction;
import prefuse.data.expression.LeftFunction;
import prefuse.data.expression.LengthFunction;
import prefuse.data.expression.Log10Function;
import prefuse.data.expression.Log2Function;
import prefuse.data.expression.LogFunction;
import prefuse.data.expression.LowerFunction;
import prefuse.data.expression.MaxFunction;
import prefuse.data.expression.OutDegreeFunction;
import prefuse.data.expression.PiFunction;
import prefuse.data.expression.PositionFunction;
import prefuse.data.expression.PowFunction;
import prefuse.data.expression.RGBAFunction;
import prefuse.data.expression.RGBFunction;
import prefuse.data.expression.RPadFunction;
import prefuse.data.expression.RadiansFunction;
import prefuse.data.expression.RandFunction;
import prefuse.data.expression.RepeatFunction;
import prefuse.data.expression.ReplaceFunction;
import prefuse.data.expression.ReverseFunction;
import prefuse.data.expression.RightFunction;
import prefuse.data.expression.RoundFunction;
import prefuse.data.expression.RowFunction;
import prefuse.data.expression.SafeLog10Function;
import prefuse.data.expression.SafeSqrtFunction;
import prefuse.data.expression.SignFunction;
import prefuse.data.expression.SinFunction;
import prefuse.data.expression.SpaceFunction;
import prefuse.data.expression.SqrtFunction;
import prefuse.data.expression.SubstringFunction;
import prefuse.data.expression.SumFunction;
import prefuse.data.expression.TanFunction;
import prefuse.data.expression.TreeDepthFunction;
import prefuse.data.expression.UpperFunction;
import prefuse.visual.expression.GroupSizeFunction;
import prefuse.visual.expression.HoverPredicate;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.expression.QueryExpression;
import prefuse.visual.expression.SearchPredicate;
import prefuse.visual.expression.ValidatedPredicate;
import prefuse.visual.expression.VisiblePredicate;

public class FunctionTable {
    private static HashMap s_functionTable = new HashMap();

    private FunctionTable() {
    }

    public static boolean hasFunction(String string) {
        return s_functionTable.containsKey(string);
    }

    public static void addFunction(String string, Class clazz) {
        if (!Function.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Type argument must be a subclass of FunctionExpression.");
        }
        if (FunctionTable.hasFunction(string)) {
            throw new IllegalArgumentException("Function with that name already exists");
        }
        String string2 = string.toLowerCase();
        String string3 = string.toUpperCase();
        if (!string.equals(string2) && !string.equals(string3)) {
            throw new IllegalArgumentException("Name can't have mixed case, try \"" + string3 + "\" instead.");
        }
        s_functionTable.put(string2, clazz);
        s_functionTable.put(string3, clazz);
    }

    public static Function createFunction(String string) {
        Class clazz = (Class)s_functionTable.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("Unrecognized function name");
        }
        try {
            return (Function)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    static {
        FunctionTable.addFunction("ROW", RowFunction.class);
        FunctionTable.addFunction("ISNODE", IsNodeFunction.class);
        FunctionTable.addFunction("ISEDGE", IsEdgeFunction.class);
        FunctionTable.addFunction("DEGREE", DegreeFunction.class);
        FunctionTable.addFunction("INDEGREE", InDegreeFunction.class);
        FunctionTable.addFunction("OUTDEGREE", OutDegreeFunction.class);
        FunctionTable.addFunction("CHILDCOUNT", ChildCountFunction.class);
        FunctionTable.addFunction("TREEDEPTH", TreeDepthFunction.class);
        FunctionTable.addFunction("ABS", AbsFunction.class);
        FunctionTable.addFunction("ACOS", AcosFunction.class);
        FunctionTable.addFunction("ASIN", AsinFunction.class);
        FunctionTable.addFunction("ATAN", AtanFunction.class);
        FunctionTable.addFunction("ATAN2", Atan2Function.class);
        FunctionTable.addFunction("CEIL", CeilFunction.class);
        FunctionTable.addFunction("CEILING", CeilFunction.class);
        FunctionTable.addFunction("COS", CosFunction.class);
        FunctionTable.addFunction("COT", CotFunction.class);
        FunctionTable.addFunction("DEGREES", DegreesFunction.class);
        FunctionTable.addFunction("E", EFunction.class);
        FunctionTable.addFunction("EXP", ExpFunction.class);
        FunctionTable.addFunction("FLOOR", FloorFunction.class);
        FunctionTable.addFunction("LOG", LogFunction.class);
        FunctionTable.addFunction("LOG2", Log2Function.class);
        FunctionTable.addFunction("LOG10", Log10Function.class);
        FunctionTable.addFunction("MAX", MaxFunction.class);
        FunctionTable.addFunction("MIN", MaxFunction.class);
        FunctionTable.addFunction("MOD", MaxFunction.class);
        FunctionTable.addFunction("PI", PiFunction.class);
        FunctionTable.addFunction("POW", PowFunction.class);
        FunctionTable.addFunction("POWER", PowFunction.class);
        FunctionTable.addFunction("RADIANS", RadiansFunction.class);
        FunctionTable.addFunction("RAND", RandFunction.class);
        FunctionTable.addFunction("ROUND", RoundFunction.class);
        FunctionTable.addFunction("SIGN", SignFunction.class);
        FunctionTable.addFunction("SIN", SinFunction.class);
        FunctionTable.addFunction("SQRT", SqrtFunction.class);
        FunctionTable.addFunction("SUM", SumFunction.class);
        FunctionTable.addFunction("TAN", TanFunction.class);
        FunctionTable.addFunction("SAFELOG10", SafeLog10Function.class);
        FunctionTable.addFunction("SAFESQRT", SafeSqrtFunction.class);
        FunctionTable.addFunction("CAP", CapFunction.class);
        FunctionTable.addFunction("CONCAT", ConcatFunction.class);
        FunctionTable.addFunction("CONCAT_WS", ConcatWsFunction.class);
        FunctionTable.addFunction("FORMAT", FormatFunction.class);
        FunctionTable.addFunction("INSERT", RPadFunction.class);
        FunctionTable.addFunction("LENGTH", LengthFunction.class);
        FunctionTable.addFunction("LOWER", LowerFunction.class);
        FunctionTable.addFunction("LCASE", LowerFunction.class);
        FunctionTable.addFunction("LEFT", LeftFunction.class);
        FunctionTable.addFunction("LPAD", LPadFunction.class);
        FunctionTable.addFunction("MID", SubstringFunction.class);
        FunctionTable.addFunction("POSITION", PositionFunction.class);
        FunctionTable.addFunction("REVERSE", ReverseFunction.class);
        FunctionTable.addFunction("REPEAT", RepeatFunction.class);
        FunctionTable.addFunction("REPLACE", ReplaceFunction.class);
        FunctionTable.addFunction("RIGHT", RightFunction.class);
        FunctionTable.addFunction("RPAD", RPadFunction.class);
        FunctionTable.addFunction("SPACE", SpaceFunction.class);
        FunctionTable.addFunction("SUBSTRING", SubstringFunction.class);
        FunctionTable.addFunction("UPPER", UpperFunction.class);
        FunctionTable.addFunction("UCASE", UpperFunction.class);
        FunctionTable.addFunction("RGB", RGBFunction.class);
        FunctionTable.addFunction("RGBA", RGBAFunction.class);
        FunctionTable.addFunction("GRAY", GrayFunction.class);
        FunctionTable.addFunction("HEX", HexFunction.class);
        FunctionTable.addFunction("HSB", HSBFunction.class);
        FunctionTable.addFunction("HSBA", HSBAFunction.class);
        FunctionTable.addFunction("COLORINTERP", ColorInterpFunction.class);
        FunctionTable.addFunction("GROUPSIZE", GroupSizeFunction.class);
        FunctionTable.addFunction("HOVER", HoverPredicate.class);
        FunctionTable.addFunction("INGROUP", InGroupPredicate.class);
        FunctionTable.addFunction("MATCH", SearchPredicate.class);
        FunctionTable.addFunction("QUERY", QueryExpression.class);
        FunctionTable.addFunction("VISIBLE", VisiblePredicate.class);
        FunctionTable.addFunction("VALIDATED", ValidatedPredicate.class);
    }
}

