/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;

public class ExpressionAnalyzer {
    public static boolean hasDependency(Expression expression) {
        ColumnCollector columnCollector = new ColumnCollector(false);
        expression.visit(columnCollector);
        return columnCollector.getColumnCount() > 0;
    }

    public static Set getReferencedColumns(Expression expression) {
        ColumnCollector columnCollector = new ColumnCollector(true);
        expression.visit(columnCollector);
        return columnCollector.getColumnSet();
    }

    private static class ColumnCollector
    implements ExpressionVisitor {
        private boolean store;
        private Set m_cols;
        private int m_count;

        public ColumnCollector(boolean bl) {
            this.store = bl;
        }

        public int getColumnCount() {
            return this.m_count;
        }

        public Set getColumnSet() {
            if (this.m_cols == null) {
                return Collections.EMPTY_SET;
            }
            return this.m_cols;
        }

        @Override
        public void visitExpression(Expression expression) {
            if (expression instanceof ColumnExpression) {
                ++this.m_count;
                if (this.store) {
                    String string = ((ColumnExpression)expression).getColumnName();
                    if (this.m_cols == null) {
                        this.m_cols = new HashSet();
                    }
                    this.m_cols.add(string);
                }
            }
        }

        @Override
        public void down() {
        }

        @Override
        public void up() {
        }
    }
}

