/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.BitSet;
import java.util.Set;
import prefuse.data.DataTypeException;
import prefuse.data.Table;
import prefuse.data.column.AbstractColumn;
import prefuse.data.column.Column;
import prefuse.data.column.ColumnFactory;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionAnalyzer;

public class ExpressionColumn
extends AbstractColumn {
    private Expression m_expr;
    private Table m_table;
    private Set m_columns;
    private BitSet m_valid;
    private Column m_cache;
    private Listener m_lstnr;

    public ExpressionColumn(Table table, Expression expression) {
        super(expression.getType(table.getSchema()));
        this.m_table = table;
        this.m_expr = expression;
        this.m_lstnr = new Listener();
        this.init();
        int n = this.m_table.getRowCount();
        this.m_cache = ColumnFactory.getColumn(this.getColumnType(), n);
        this.m_valid = new BitSet(n);
        this.m_expr.addExpressionListener(this.m_lstnr);
    }

    protected void init() {
        Column column;
        if (this.m_columns != null && this.m_columns.size() > 0) {
            for (String string : this.m_columns) {
                column = this.m_table.getColumn(string);
                column.removeColumnListener(this.m_lstnr);
            }
        }
        this.m_columns = ExpressionAnalyzer.getReferencedColumns(this.m_expr);
        for (String string : this.m_columns) {
            if (this.m_table.getColumn(string) != null) continue;
            throw new IllegalArgumentException("Table must contain all columns referenced by the expression. Bad column name: " + string);
        }
        for (String string : this.m_columns) {
            column = this.m_table.getColumn(string);
            column.addColumnListener(this.m_lstnr);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_cache.getRowCount();
    }

    @Override
    public void setMaximumRow(int n) {
        this.m_cache.setMaximumRow(n);
    }

    public boolean isCacheValid(int n) {
        return this.m_valid.get(n);
    }

    public void invalidateCache(int n, int n2) {
        this.m_valid.clear(n, n2 + 1);
    }

    @Override
    public void revertToDefault(int n) {
    }

    @Override
    public boolean canSet(Class clazz) {
        return false;
    }

    @Override
    public Object get(int n) {
        Class clazz;
        this.rangeCheck(n);
        if (this.isCacheValid(n)) {
            return this.m_cache.get(n);
        }
        Object object = this.m_expr.get(this.m_table.getTuple(n));
        Class clazz2 = clazz = object == null ? Object.class : object.getClass();
        if (this.m_cache.canSet(clazz)) {
            this.m_cache.set(object, n);
            this.m_valid.set(n);
        }
        return object;
    }

    @Override
    public void set(Object object, int n) throws DataTypeException {
        throw new UnsupportedOperationException();
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public boolean getBoolean(int n) throws DataTypeException {
        if (!this.canGetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.rangeCheck(n);
        if (this.isCacheValid(n)) {
            return this.m_cache.getBoolean(n);
        }
        boolean bl = this.m_expr.getBoolean(this.m_table.getTuple(n));
        this.m_cache.setBoolean(bl, n);
        this.m_valid.set(n);
        return bl;
    }

    private void computeNumber(int n) {
        if (this.m_columnType == Integer.TYPE || this.m_columnType == Byte.TYPE) {
            this.m_cache.setInt(this.m_expr.getInt(this.m_table.getTuple(n)), n);
        } else if (this.m_columnType == Long.TYPE) {
            this.m_cache.setLong(this.m_expr.getLong(this.m_table.getTuple(n)), n);
        } else if (this.m_columnType == Float.TYPE) {
            this.m_cache.setFloat(this.m_expr.getFloat(this.m_table.getTuple(n)), n);
        } else {
            this.m_cache.setDouble(this.m_expr.getDouble(this.m_table.getTuple(n)), n);
        }
        this.m_valid.set(n);
    }

    @Override
    public int getInt(int n) throws DataTypeException {
        if (!this.canGetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.rangeCheck(n);
        if (!this.isCacheValid(n)) {
            this.computeNumber(n);
        }
        return this.m_cache.getInt(n);
    }

    @Override
    public double getDouble(int n) throws DataTypeException {
        if (!this.canGetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.rangeCheck(n);
        if (!this.isCacheValid(n)) {
            this.computeNumber(n);
        }
        return this.m_cache.getDouble(n);
    }

    @Override
    public float getFloat(int n) throws DataTypeException {
        if (!this.canGetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.rangeCheck(n);
        if (!this.isCacheValid(n)) {
            this.computeNumber(n);
        }
        return this.m_cache.getFloat(n);
    }

    @Override
    public long getLong(int n) throws DataTypeException {
        if (!this.canGetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.rangeCheck(n);
        if (!this.isCacheValid(n)) {
            this.computeNumber(n);
        }
        return this.m_cache.getLong(n);
    }

    private class Listener
    implements ColumnListener,
    ExpressionListener {
        private Listener() {
        }

        public void columnChanged(int n, int n2) {
            if (n == n2 && ExpressionColumn.this.isCacheValid(n)) {
                if (!ExpressionColumn.this.m_table.isValidRow(n)) {
                    return;
                }
                ExpressionColumn.this.invalidateCache(n, n2);
                Class clazz = ExpressionColumn.this.getColumnType();
                if (Integer.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n, ExpressionColumn.this.m_cache.getInt(n));
                } else if (Long.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n, ExpressionColumn.this.m_cache.getLong(n));
                } else if (Float.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n, ExpressionColumn.this.m_cache.getFloat(n));
                } else if (Double.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n, ExpressionColumn.this.m_cache.getDouble(n));
                } else if (Boolean.TYPE == clazz) {
                    ExpressionColumn.this.fireColumnEvent(n, ExpressionColumn.this.m_cache.getBoolean(n));
                } else {
                    ExpressionColumn.this.fireColumnEvent(n, ExpressionColumn.this.m_cache.get(n));
                }
            } else {
                ExpressionColumn.this.invalidateCache(n, n2);
                ExpressionColumn.this.fireColumnEvent(0, n, n2);
            }
        }

        @Override
        public void columnChanged(Column column, int n, boolean bl) {
            this.columnChanged(n, n);
        }

        @Override
        public void columnChanged(Column column, int n, double d) {
            this.columnChanged(n, n);
        }

        @Override
        public void columnChanged(Column column, int n, float f) {
            this.columnChanged(n, n);
        }

        @Override
        public void columnChanged(Column column, int n, int n2, int n3) {
            this.columnChanged(n2, n3);
        }

        @Override
        public void columnChanged(Column column, int n, int n2) {
            this.columnChanged(n, n);
        }

        @Override
        public void columnChanged(Column column, int n, long l) {
            this.columnChanged(n, n);
        }

        @Override
        public void columnChanged(Column column, int n, Object object) {
            this.columnChanged(n, n);
        }

        @Override
        public void expressionChanged(Expression expression) {
            this.columnChanged(0, ExpressionColumn.this.m_cache.getRowCount() - 1);
            ExpressionColumn.this.init();
        }
    }
}

