/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleManager;
import prefuse.visual.tuple.TableEdgeItem;

public class SpanningTree
extends Tree {
    public static final String SOURCE_EDGE = "source";
    protected static final Schema EDGE_SCHEMA = new Schema();
    protected Graph m_backing;

    public SpanningTree(Graph graph, Node node) {
        super(graph.getNodeTable(), EDGE_SCHEMA.instantiate());
        this.m_backing = graph;
        TupleManager tupleManager = new TupleManager(this.getEdgeTable(), null, TableEdgeItem.class){

            @Override
            public Tuple getTuple(int n) {
                return SpanningTree.this.m_backing.getEdge(this.m_table.getInt(n, SpanningTree.SOURCE_EDGE));
            }
        };
        this.getEdgeTable().setTupleManager(tupleManager);
        super.setTupleManagers(graph.m_nodeTuples, tupleManager);
        this.buildSpanningTree(node);
    }

    public void buildSpanningTree(Node node) {
        super.clearEdges();
        super.setRoot(node);
        LinkedList<Node> linkedList = new LinkedList<Node>();
        BitSet bitSet = new BitSet();
        linkedList.add(node);
        bitSet.set(node.getRow());
        Table table = this.getEdgeTable();
        while (!linkedList.isEmpty()) {
            Node node2 = (Node)linkedList.removeFirst();
            Iterator iterator = node2.edges();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                Node node3 = edge.getAdjacentNode(node2);
                if (bitSet.get(node3.getRow())) continue;
                linkedList.add(node3);
                bitSet.set(node3.getRow());
                int n = super.addChildEdge(node2.getRow(), node3.getRow());
                table.setInt(n, SOURCE_EDGE, edge.getRow());
            }
        }
    }

    @Override
    public int addChild(int n) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public Node addChild(Node node) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public int addChildEdge(int n, int n2) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public Edge addChildEdge(Node node, Node node2) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public Node addRoot() {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public int addRootRow() {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChild(int n) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChild(Node node) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChildEdge(Edge edge) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeChildEdge(int n) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    void setRoot(Node node) {
        throw new UnsupportedOperationException("Changes to tree structure not allowed for spanning trees.");
    }

    @Override
    public int addEdge(int n, int n2) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public Edge addEdge(Node node, Node node2) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public Node addNode() {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public int addNodeRow() {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeEdge(Edge edge) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeEdge(int n) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeNode(int n) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeNode(Node node) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public void setEdgeTable(Table table) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    @Override
    public void setTupleManagers(TupleManager tupleManager, TupleManager tupleManager2) {
        throw new UnsupportedOperationException("Changes to graph structure not allowed for spanning trees.");
    }

    static {
        EDGE_SCHEMA.addColumn(DEFAULT_SOURCE_KEY, Integer.TYPE, new Integer(-1));
        EDGE_SCHEMA.addColumn(DEFAULT_TARGET_KEY, Integer.TYPE, new Integer(-1));
        EDGE_SCHEMA.addColumn(SOURCE_EDGE, Integer.TYPE);
    }
}

