/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.activity.Activity;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.ControlAdapter;

public class ZoomingPanControl
extends ControlAdapter {
    private boolean repaint = true;
    private boolean started = false;
    private Point mouseDown;
    private Point mouseCur;
    private Point mouseUp;
    private int dx;
    private int dy;
    private double d = 0.0;
    private double v0 = 75.0;
    private double d0 = 50.0;
    private double d1 = 400.0;
    private double s0 = 0.1;
    private UpdateActivity update = new UpdateActivity();
    private FinishActivity finish = new FinishActivity();

    public ZoomingPanControl() {
        this(true);
    }

    public ZoomingPanControl(boolean bl) {
        this.repaint = bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Display display = (Display)mouseEvent.getComponent();
            display.setCursor(Cursor.getPredefinedCursor(13));
            this.mouseDown = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.mouseCur = mouseEvent.getPoint();
            this.dx = this.mouseCur.x - this.mouseDown.x;
            this.dy = this.mouseCur.y - this.mouseDown.y;
            this.d = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            if (!this.started) {
                Display display = (Display)mouseEvent.getComponent();
                this.update.setDisplay(display);
                this.update.run();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.update.cancel();
            this.started = false;
            Display display = (Display)mouseEvent.getComponent();
            this.mouseUp = mouseEvent.getPoint();
            this.finish.setDisplay(display);
            this.finish.run();
            display.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class FinishActivity
    extends Activity {
        private Display display;
        private double scale;

        public FinishActivity() {
            super(1500L, 15L, 0L);
            this.setPacingFunction(new SlowInSlowOutPacer());
        }

        public void setDisplay(Display display) {
            this.display = display;
            this.scale = display.getTransform().getScaleX();
            double d = this.scale < 1.0 ? 1.0 / this.scale : this.scale;
            this.setDuration((long)(500.0 + 500.0 * Math.log(1.0 + d)));
        }

        @Override
        protected void run(long l) {
            double d = this.getPace(l);
            double d2 = this.display.getTransform().getScaleX();
            double d3 = (d + (1.0 - d) * this.scale) / d2;
            this.display.zoom(ZoomingPanControl.this.mouseUp, d3);
            if (ZoomingPanControl.this.repaint) {
                this.display.repaint();
            }
        }
    }

    private class UpdateActivity
    extends Activity {
        private Display display;
        private long lastTime;

        public UpdateActivity() {
            super(-1L, 15L, 0L);
            this.lastTime = 0L;
        }

        public void setDisplay(Display display) {
            this.display = display;
        }

        @Override
        protected void run(long l) {
            double d;
            double d2;
            double d3 = this.display.getTransform().getScaleX();
            if (ZoomingPanControl.this.d <= ZoomingPanControl.this.d0) {
                d2 = 1.0;
                d = ZoomingPanControl.this.v0 * (ZoomingPanControl.this.d / ZoomingPanControl.this.d0);
            } else {
                d2 = ZoomingPanControl.this.d >= ZoomingPanControl.this.d1 ? ZoomingPanControl.this.s0 : Math.pow(ZoomingPanControl.this.s0, (ZoomingPanControl.this.d - ZoomingPanControl.this.d0) / (ZoomingPanControl.this.d1 - ZoomingPanControl.this.d0));
                d = ZoomingPanControl.this.v0;
            }
            d2 /= d3;
            double d4 = d * (double)(l - this.lastTime) / 1000.0;
            this.lastTime = l;
            double d5 = -d4 * (double)ZoomingPanControl.this.dx / ZoomingPanControl.this.d;
            double d6 = -d4 * (double)ZoomingPanControl.this.dy / ZoomingPanControl.this.d;
            this.display.pan(d5, d6);
            if (d2 != 1.0) {
                this.display.zoom(ZoomingPanControl.this.mouseCur, d2);
            }
            if (ZoomingPanControl.this.repaint) {
                this.display.repaint();
            }
        }
    }
}

