/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class ZoomToFitControl
extends ControlAdapter {
    private long m_duration = 2000L;
    private int m_margin = 50;
    private int m_button = 4;
    private boolean m_zoomOverItem = true;
    private String m_group = Visualization.ALL_ITEMS;

    public ZoomToFitControl() {
    }

    public ZoomToFitControl(String string) {
        this.m_group = string;
    }

    public ZoomToFitControl(int n) {
        this.m_button = n;
    }

    public ZoomToFitControl(String string, int n) {
        this.m_group = string;
        this.m_button = n;
    }

    public ZoomToFitControl(String string, int n, long l, int n2) {
        this.m_group = string;
        this.m_margin = n;
        this.m_duration = l;
        this.m_button = n2;
    }

    @Override
    public void itemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_zoomOverItem) {
            this.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getComponent();
        if (!display.isTranformInProgress() && UILib.isButtonPressed(mouseEvent, this.m_button)) {
            Visualization visualization = display.getVisualization();
            Rectangle2D rectangle2D = visualization.getBounds(this.m_group);
            GraphicsLib.expand(rectangle2D, this.m_margin + (int)(1.0 / display.getScale()));
            DisplayLib.fitViewToBounds(display, rectangle2D, this.m_duration);
        }
    }

    public boolean isZoomOverItem() {
        return this.m_zoomOverItem;
    }

    public void setZoomOverItem(boolean bl) {
        this.m_zoomOverItem = bl;
    }

    public int getMargin() {
        return this.m_margin;
    }

    public void setMargin(int n) {
        this.m_margin = n;
    }
}

