/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import prefuse.Display;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ArrayLib;
import prefuse.visual.NodeItem;

public class NodeLinkTreeLayout
extends TreeLayout {
    private int m_orientation;
    private double m_bspace = 5.0;
    private double m_tspace = 25.0;
    private double m_dspace = 50.0;
    private double m_offset = 50.0;
    private double[] m_depths = new double[10];
    private int m_maxDepth = 0;
    private double m_ax;
    private double m_ay;
    public static final String PARAMS = "_reingoldTilfordParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public NodeLinkTreeLayout(String string) {
        super(string);
        this.m_orientation = 0;
    }

    public NodeLinkTreeLayout(String string, int n, double d, double d2, double d3) {
        super(string);
        this.m_orientation = n;
        this.m_dspace = d;
        this.m_bspace = d2;
        this.m_tspace = d3;
    }

    public void setOrientation(int n) {
        if (n < 0 || n >= 5 || n == 4) {
            throw new IllegalArgumentException("Unsupported orientation value: " + n);
        }
        this.m_orientation = n;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setDepthSpacing(double d) {
        this.m_dspace = d;
    }

    public double getDepthSpacing() {
        return this.m_dspace;
    }

    public void setBreadthSpacing(double d) {
        this.m_bspace = d;
    }

    public double getBreadthSpacing() {
        return this.m_bspace;
    }

    public void setSubtreeSpacing(double d) {
        this.m_tspace = d;
    }

    public double getSubtreeSpacing() {
        return this.m_tspace;
    }

    public void setRootNodeOffset(double d) {
        this.m_offset = d;
    }

    public double getRootNodeOffset() {
        return this.m_offset;
    }

    @Override
    public Point2D getLayoutAnchor() {
        if (this.m_anchor != null) {
            return this.m_anchor;
        }
        this.m_tmpa.setLocation(0.0, 0.0);
        if (this.m_vis != null) {
            Display display = this.m_vis.getDisplay(0);
            Rectangle2D rectangle2D = this.getLayoutBounds();
            switch (this.m_orientation) {
                case 0: {
                    this.m_tmpa.setLocation(this.m_offset, (double)display.getHeight() / 2.0);
                    break;
                }
                case 1: {
                    this.m_tmpa.setLocation(rectangle2D.getMaxX() - this.m_offset, (double)display.getHeight() / 2.0);
                    break;
                }
                case 2: {
                    this.m_tmpa.setLocation((double)display.getWidth() / 2.0, this.m_offset);
                    break;
                }
                case 3: {
                    this.m_tmpa.setLocation((double)display.getWidth() / 2.0, rectangle2D.getMaxY() - this.m_offset);
                }
            }
            display.getInverseTransform().transform(this.m_tmpa, this.m_tmpa);
        }
        return this.m_tmpa;
    }

    private double spacing(NodeItem nodeItem, NodeItem nodeItem2, boolean bl) {
        boolean bl2 = this.m_orientation == 2 || this.m_orientation == 3;
        return (bl ? this.m_bspace : this.m_tspace) + 0.5 * (bl2 ? nodeItem.getBounds().getWidth() + nodeItem2.getBounds().getWidth() : nodeItem.getBounds().getHeight() + nodeItem2.getBounds().getHeight());
    }

    private void updateDepths(int n, NodeItem nodeItem) {
        double d;
        boolean bl = this.m_orientation == 2 || this.m_orientation == 3;
        double d2 = d = bl ? nodeItem.getBounds().getHeight() : nodeItem.getBounds().getWidth();
        if (this.m_depths.length <= n) {
            this.m_depths = ArrayLib.resize(this.m_depths, 3 * n / 2);
        }
        this.m_depths[n] = Math.max(this.m_depths[n], d);
        this.m_maxDepth = Math.max(this.m_maxDepth, n);
    }

    private void determineDepths() {
        for (int i = 1; i < this.m_maxDepth; ++i) {
            int n = i;
            this.m_depths[n] = this.m_depths[n] + (this.m_depths[i - 1] + this.m_dspace);
        }
    }

    @Override
    public void run(double d) {
        Graph graph = (Graph)this.m_vis.getGroup(this.m_group);
        this.initSchema(graph.getNodes());
        Arrays.fill(this.m_depths, 0.0);
        this.m_maxDepth = 0;
        Point2D point2D = this.getLayoutAnchor();
        this.m_ax = point2D.getX();
        this.m_ay = point2D.getY();
        NodeItem nodeItem = this.getLayoutRoot();
        Params params = this.getParams(nodeItem);
        this.firstWalk(nodeItem, 0, 1);
        this.determineDepths();
        this.secondWalk(nodeItem, null, -params.prelim, 0);
    }

    private void firstWalk(NodeItem nodeItem, int n, int n2) {
        Params params = this.getParams(nodeItem);
        params.number = n;
        this.updateDepths(n2, nodeItem);
        boolean bl = nodeItem.isExpanded();
        if (nodeItem.getChildCount() == 0 || !bl) {
            NodeItem nodeItem2 = (NodeItem)nodeItem.getPreviousSibling();
            params.prelim = nodeItem2 == null ? 0.0 : this.getParams((NodeItem)nodeItem2).prelim + this.spacing(nodeItem2, nodeItem, true);
        } else if (bl) {
            NodeItem nodeItem3 = (NodeItem)nodeItem.getFirstChild();
            NodeItem nodeItem4 = (NodeItem)nodeItem.getLastChild();
            NodeItem nodeItem5 = nodeItem3;
            int n3 = 0;
            for (NodeItem nodeItem6 = nodeItem3; nodeItem6 != null; nodeItem6 = (NodeItem)nodeItem6.getNextSibling()) {
                this.firstWalk(nodeItem6, n3, n2 + 1);
                nodeItem5 = this.apportion(nodeItem6, nodeItem5);
                ++n3;
            }
            this.executeShifts(nodeItem);
            double d = 0.5 * (this.getParams((NodeItem)nodeItem3).prelim + this.getParams((NodeItem)nodeItem4).prelim);
            NodeItem nodeItem7 = (NodeItem)nodeItem.getPreviousSibling();
            if (nodeItem7 != null) {
                params.prelim = this.getParams((NodeItem)nodeItem7).prelim + this.spacing(nodeItem7, nodeItem, true);
                params.mod = params.prelim - d;
            } else {
                params.prelim = d;
            }
        }
    }

    private NodeItem apportion(NodeItem nodeItem, NodeItem nodeItem2) {
        NodeItem nodeItem3 = (NodeItem)nodeItem.getPreviousSibling();
        if (nodeItem3 != null) {
            NodeItem nodeItem4;
            NodeItem nodeItem5 = nodeItem4 = nodeItem;
            NodeItem nodeItem6 = nodeItem3;
            NodeItem nodeItem7 = (NodeItem)nodeItem5.getParent().getFirstChild();
            double d = this.getParams((NodeItem)nodeItem5).mod;
            double d2 = this.getParams((NodeItem)nodeItem4).mod;
            double d3 = this.getParams((NodeItem)nodeItem6).mod;
            double d4 = this.getParams((NodeItem)nodeItem7).mod;
            NodeItem nodeItem8 = this.nextRight(nodeItem6);
            NodeItem nodeItem9 = this.nextLeft(nodeItem5);
            while (nodeItem8 != null && nodeItem9 != null) {
                nodeItem6 = nodeItem8;
                nodeItem5 = nodeItem9;
                nodeItem7 = this.nextLeft(nodeItem7);
                nodeItem4 = this.nextRight(nodeItem4);
                this.getParams((NodeItem)nodeItem4).ancestor = nodeItem;
                double d5 = this.getParams((NodeItem)nodeItem6).prelim + d3 - (this.getParams((NodeItem)nodeItem5).prelim + d) + this.spacing(nodeItem6, nodeItem5, false);
                if (d5 > 0.0) {
                    this.moveSubtree(this.ancestor(nodeItem6, nodeItem, nodeItem2), nodeItem, d5);
                    d += d5;
                    d2 += d5;
                }
                d3 += this.getParams((NodeItem)nodeItem6).mod;
                d += this.getParams((NodeItem)nodeItem5).mod;
                d4 += this.getParams((NodeItem)nodeItem7).mod;
                d2 += this.getParams((NodeItem)nodeItem4).mod;
                nodeItem8 = this.nextRight(nodeItem6);
                nodeItem9 = this.nextLeft(nodeItem5);
            }
            if (nodeItem8 != null && this.nextRight(nodeItem4) == null) {
                Params params = this.getParams(nodeItem4);
                params.thread = nodeItem8;
                params.mod += d3 - d2;
            }
            if (nodeItem9 != null && this.nextLeft(nodeItem7) == null) {
                Params params = this.getParams(nodeItem7);
                params.thread = nodeItem9;
                params.mod += d - d4;
                nodeItem2 = nodeItem;
            }
        }
        return nodeItem2;
    }

    private NodeItem nextLeft(NodeItem nodeItem) {
        NodeItem nodeItem2 = null;
        if (nodeItem.isExpanded()) {
            nodeItem2 = (NodeItem)nodeItem.getFirstChild();
        }
        return nodeItem2 != null ? nodeItem2 : this.getParams((NodeItem)nodeItem).thread;
    }

    private NodeItem nextRight(NodeItem nodeItem) {
        NodeItem nodeItem2 = null;
        if (nodeItem.isExpanded()) {
            nodeItem2 = (NodeItem)nodeItem.getLastChild();
        }
        return nodeItem2 != null ? nodeItem2 : this.getParams((NodeItem)nodeItem).thread;
    }

    private void moveSubtree(NodeItem nodeItem, NodeItem nodeItem2, double d) {
        Params params = this.getParams(nodeItem);
        Params params2 = this.getParams(nodeItem2);
        double d2 = params2.number - params.number;
        params2.change -= d / d2;
        params2.shift += d;
        params.change += d / d2;
        params2.prelim += d;
        params2.mod += d;
    }

    private void executeShifts(NodeItem nodeItem) {
        double d = 0.0;
        double d2 = 0.0;
        for (NodeItem nodeItem2 = (NodeItem)nodeItem.getLastChild(); nodeItem2 != null; nodeItem2 = (NodeItem)nodeItem2.getPreviousSibling()) {
            Params params = this.getParams(nodeItem2);
            params.prelim += d;
            params.mod += d;
            d += params.shift + (d2 += params.change);
        }
    }

    private NodeItem ancestor(NodeItem nodeItem, NodeItem nodeItem2, NodeItem nodeItem3) {
        NodeItem nodeItem4 = (NodeItem)nodeItem2.getParent();
        Params params = this.getParams(nodeItem);
        if (params.ancestor.getParent() == nodeItem4) {
            return params.ancestor;
        }
        return nodeItem3;
    }

    private void secondWalk(NodeItem nodeItem, NodeItem nodeItem2, double d, int n) {
        Params params = this.getParams(nodeItem);
        this.setBreadth(nodeItem, nodeItem2, params.prelim + d);
        this.setDepth(nodeItem, nodeItem2, this.m_depths[n]);
        if (nodeItem.isExpanded()) {
            ++n;
            for (NodeItem nodeItem3 = (NodeItem)nodeItem.getFirstChild(); nodeItem3 != null; nodeItem3 = (NodeItem)nodeItem3.getNextSibling()) {
                this.secondWalk(nodeItem3, nodeItem, d + params.mod, n);
            }
        }
        params.clear();
    }

    private void setBreadth(NodeItem nodeItem, NodeItem nodeItem2, double d) {
        switch (this.m_orientation) {
            case 0: 
            case 1: {
                this.setY(nodeItem, nodeItem2, this.m_ay + d);
                break;
            }
            case 2: 
            case 3: {
                this.setX(nodeItem, nodeItem2, this.m_ax + d);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void setDepth(NodeItem nodeItem, NodeItem nodeItem2, double d) {
        switch (this.m_orientation) {
            case 0: {
                this.setX(nodeItem, nodeItem2, this.m_ax + d);
                break;
            }
            case 1: {
                this.setX(nodeItem, nodeItem2, this.m_ax - d);
                break;
            }
            case 2: {
                this.setY(nodeItem, nodeItem2, this.m_ay + d);
                break;
            }
            case 3: {
                this.setY(nodeItem, nodeItem2, this.m_ay - d);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void initSchema(TupleSet tupleSet) {
        tupleSet.addColumns(PARAMS_SCHEMA);
    }

    private Params getParams(NodeItem nodeItem) {
        Params params = (Params)nodeItem.get(PARAMS);
        if (params == null) {
            params = new Params();
            nodeItem.set(PARAMS, (Object)params);
        }
        if (params.number == -2) {
            params.init(nodeItem);
        }
        return params;
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class);
    }

    public static class Params
    implements Cloneable {
        double prelim;
        double mod;
        double shift;
        double change;
        int number = -2;
        NodeItem ancestor = null;
        NodeItem thread = null;

        public void init(NodeItem nodeItem) {
            this.ancestor = nodeItem;
            this.number = -1;
        }

        public void clear() {
            this.number = -2;
            this.change = 0.0;
            this.shift = 0.0;
            this.mod = 0.0;
            this.prelim = 0.0;
            this.thread = null;
            this.ancestor = null;
        }
    }
}

