/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Random;
import prefuse.action.layout.Layout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.PrefuseLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class FruchtermanReingoldLayout
extends Layout {
    private double forceConstant;
    private double temp;
    private int maxIter = 700;
    protected String m_nodeGroup;
    protected String m_edgeGroup;
    protected int m_fidx;
    private static final double EPSILON = 1.0E-6;
    private static final double ALPHA = 0.1;
    public static final String PARAMS = "_fruchtermanReingoldParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public FruchtermanReingoldLayout(String string) {
        this(string, 700);
    }

    public FruchtermanReingoldLayout(String string, int n) {
        super(string);
        this.m_nodeGroup = PrefuseLib.getGroupName(string, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(string, Graph.EDGES);
        this.maxIter = n;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    @Override
    public void run(double d) {
        Graph graph = (Graph)this.m_vis.getGroup(this.m_group);
        Rectangle2D rectangle2D = super.getLayoutBounds();
        this.init(graph, rectangle2D);
        for (int i = 0; i < this.maxIter; ++i) {
            VisualItem visualItem;
            Iterator iterator = graph.nodes();
            while (iterator.hasNext()) {
                visualItem = (NodeItem)iterator.next();
                if (visualItem.isFixed()) continue;
                this.calcRepulsion(graph, (NodeItem)visualItem);
            }
            iterator = graph.edges();
            while (iterator.hasNext()) {
                visualItem = (EdgeItem)iterator.next();
                this.calcAttraction((EdgeItem)visualItem);
            }
            iterator = graph.nodes();
            while (iterator.hasNext()) {
                visualItem = (NodeItem)iterator.next();
                if (visualItem.isFixed()) continue;
                this.calcPositions((NodeItem)visualItem, rectangle2D);
            }
            this.cool(i);
        }
        this.finish(graph);
    }

    private void init(Graph graph, Rectangle2D rectangle2D) {
        this.initSchema(graph.getNodes());
        this.temp = rectangle2D.getWidth() / 10.0;
        this.forceConstant = 0.75 * Math.sqrt(rectangle2D.getHeight() * rectangle2D.getWidth() / (double)graph.getNodeCount());
        Iterator iterator = graph.nodes();
        Random random = new Random(42L);
        double d = 0.1 * rectangle2D.getWidth() / 2.0;
        double d2 = 0.1 * rectangle2D.getHeight() / 2.0;
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            Params params = this.getParams(nodeItem);
            params.loc[0] = rectangle2D.getCenterX() + random.nextDouble() * d;
            params.loc[1] = rectangle2D.getCenterY() + random.nextDouble() * d2;
        }
    }

    private void finish(Graph graph) {
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            Params params = this.getParams(nodeItem);
            this.setX(nodeItem, null, params.loc[0]);
            this.setY(nodeItem, null, params.loc[1]);
        }
    }

    public void calcPositions(NodeItem nodeItem, Rectangle2D rectangle2D) {
        Params params = this.getParams(nodeItem);
        double d = Math.max(1.0E-6, Math.sqrt(params.disp[0] * params.disp[0] + params.disp[1] * params.disp[1]));
        double d2 = params.disp[0] / d * Math.min(d, this.temp);
        if (Double.isNaN(d2)) {
            System.err.println("Mathematical error... (calcPositions:xDisp)");
        }
        double d3 = params.disp[1] / d * Math.min(d, this.temp);
        params.loc[0] = params.loc[0] + d2;
        params.loc[1] = params.loc[1] + d3;
        double d4 = rectangle2D.getWidth() / 50.0;
        double d5 = params.loc[0];
        if (d5 < rectangle2D.getMinX() + d4) {
            d5 = rectangle2D.getMinX() + d4 + Math.random() * d4 * 2.0;
        } else if (d5 > rectangle2D.getMaxX() - d4) {
            d5 = rectangle2D.getMaxX() - d4 - Math.random() * d4 * 2.0;
        }
        double d6 = params.loc[1];
        if (d6 < rectangle2D.getMinY() + d4) {
            d6 = rectangle2D.getMinY() + d4 + Math.random() * d4 * 2.0;
        } else if (d6 > rectangle2D.getMaxY() - d4) {
            d6 = rectangle2D.getMaxY() - d4 - Math.random() * d4 * 2.0;
        }
        params.loc[0] = d5;
        params.loc[1] = d6;
    }

    public void calcAttraction(EdgeItem edgeItem) {
        NodeItem nodeItem = edgeItem.getSourceItem();
        Params params = this.getParams(nodeItem);
        NodeItem nodeItem2 = edgeItem.getTargetItem();
        Params params2 = this.getParams(nodeItem2);
        double d = params.loc[0] - params2.loc[0];
        double d2 = params.loc[1] - params2.loc[1];
        double d3 = Math.max(1.0E-6, Math.sqrt(d * d + d2 * d2));
        double d4 = d3 * d3 / this.forceConstant;
        if (Double.isNaN(d4)) {
            System.err.println("Mathematical error...");
        }
        double d5 = d / d3 * d4;
        double d6 = d2 / d3 * d4;
        params.disp[0] = params.disp[0] - d5;
        params.disp[1] = params.disp[1] - d6;
        params2.disp[0] = params2.disp[0] + d5;
        params2.disp[1] = params2.disp[1] + d6;
    }

    public void calcRepulsion(Graph graph, NodeItem nodeItem) {
        Params params = this.getParams(nodeItem);
        params.disp[0] = 0.0;
        params.disp[1] = 0.0;
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            Params params2 = this.getParams(nodeItem2);
            if (nodeItem2.isFixed() || nodeItem == nodeItem2) continue;
            double d = params.loc[0] - params2.loc[0];
            double d2 = params.loc[1] - params2.loc[1];
            double d3 = Math.max(1.0E-6, Math.sqrt(d * d + d2 * d2));
            double d4 = this.forceConstant * this.forceConstant / d3;
            if (Double.isNaN(d4)) {
                System.err.println("Mathematical error...");
            }
            params.disp[0] = params.disp[0] + d / d3 * d4;
            params.disp[1] = params.disp[1] + d2 / d3 * d4;
        }
    }

    private void cool(int n) {
        this.temp *= 1.0 - (double)n / (double)this.maxIter;
    }

    protected void initSchema(TupleSet tupleSet) {
        try {
            tupleSet.addColumns(PARAMS_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Params getParams(VisualItem visualItem) {
        Params params = (Params)visualItem.get(PARAMS);
        if (params == null) {
            params = new Params();
            visualItem.set(PARAMS, (Object)params);
        }
        return params;
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class);
    }

    public static class Params
    implements Cloneable {
        double[] loc = new double[2];
        double[] disp = new double[2];
    }
}

