/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.PrefuseLib;
import prefuse.util.force.DragForce;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.NBodyForce;
import prefuse.util.force.SpringForce;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class ForceDirectedLayout
extends Layout {
    private ForceSimulator m_fsim;
    private long m_lasttime = -1L;
    private long m_maxstep = 50L;
    private boolean m_runonce;
    private int m_iterations = 100;
    private boolean m_enforceBounds;
    protected transient VisualItem referrer;
    protected String m_nodeGroup;
    protected String m_edgeGroup;
    public static final String FORCEITEM = "_forceItem";
    public static final Schema FORCEITEM_SCHEMA = new Schema();

    public ForceDirectedLayout(String string) {
        this(string, false, false);
    }

    public ForceDirectedLayout(String string, boolean bl) {
        this(string, bl, false);
    }

    public ForceDirectedLayout(String string, boolean bl, boolean bl2) {
        super(string);
        this.m_nodeGroup = PrefuseLib.getGroupName(string, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(string, Graph.EDGES);
        this.m_enforceBounds = bl;
        this.m_runonce = bl2;
        this.m_fsim = new ForceSimulator();
        this.m_fsim.addForce(new NBodyForce());
        this.m_fsim.addForce(new SpringForce());
        this.m_fsim.addForce(new DragForce());
    }

    public ForceDirectedLayout(String string, ForceSimulator forceSimulator, boolean bl) {
        this(string, forceSimulator, bl, false);
    }

    public ForceDirectedLayout(String string, ForceSimulator forceSimulator, boolean bl, boolean bl2) {
        super(string);
        this.m_nodeGroup = PrefuseLib.getGroupName(string, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(string, Graph.EDGES);
        this.m_enforceBounds = bl;
        this.m_runonce = bl2;
        this.m_fsim = forceSimulator;
    }

    public long getMaxTimeStep() {
        return this.m_maxstep;
    }

    public void setMaxTimeStep(long l) {
        this.m_maxstep = l;
    }

    public ForceSimulator getForceSimulator() {
        return this.m_fsim;
    }

    public void setForceSimulator(ForceSimulator forceSimulator) {
        this.m_fsim = forceSimulator;
    }

    public int getIterations() {
        return this.m_iterations;
    }

    public void setIterations(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Iterations must be a positive number!");
        }
        this.m_iterations = n;
    }

    public void setDataGroups(String string, String string2) {
        this.m_nodeGroup = string;
        this.m_edgeGroup = string2;
    }

    @Override
    public void run(double d) {
        if (this.m_runonce) {
            Point2D point2D = this.getLayoutAnchor();
            Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
            while (iterator.hasNext()) {
                NodeItem nodeItem = (NodeItem)iterator.next();
                nodeItem.setX(point2D.getX());
                nodeItem.setY(point2D.getY());
            }
            this.m_fsim.clear();
            long l = 1000L;
            this.initSimulator(this.m_fsim);
            for (int i = 0; i < this.m_iterations; ++i) {
                l = (long)((double)l * (1.0 - (double)i / (double)this.m_iterations));
                long l2 = l + 50L;
                this.m_fsim.runSimulator(l2);
            }
            this.updateNodePositions();
        } else {
            if (this.m_lasttime == -1L) {
                this.m_lasttime = System.currentTimeMillis() - 20L;
            }
            long l = System.currentTimeMillis();
            long l3 = Math.min(this.m_maxstep, l - this.m_lasttime);
            this.m_lasttime = l;
            this.m_fsim.clear();
            this.initSimulator(this.m_fsim);
            this.m_fsim.runSimulator(l3);
            this.updateNodePositions();
        }
        if (d == 1.0) {
            this.reset();
        }
    }

    private void updateNodePositions() {
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (rectangle2D != null) {
            d = rectangle2D.getMinX();
            d3 = rectangle2D.getMinY();
            d2 = rectangle2D.getMaxX();
            d4 = rectangle2D.getMaxY();
        }
        Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            ForceItem forceItem = (ForceItem)visualItem.get(FORCEITEM);
            if (visualItem.isFixed()) {
                forceItem.force[0] = 0.0f;
                forceItem.force[1] = 0.0f;
                forceItem.velocity[0] = 0.0f;
                forceItem.velocity[1] = 0.0f;
                if (!Double.isNaN(visualItem.getX())) continue;
                this.setX(visualItem, this.referrer, 0.0);
                this.setY(visualItem, this.referrer, 0.0);
                continue;
            }
            double d5 = forceItem.location[0];
            double d6 = forceItem.location[1];
            if (this.m_enforceBounds && rectangle2D != null) {
                Rectangle2D rectangle2D2 = visualItem.getBounds();
                double d7 = rectangle2D2.getWidth() / 2.0;
                double d8 = rectangle2D2.getHeight() / 2.0;
                if (d5 + d7 > d2) {
                    d5 = d2 - d7;
                }
                if (d5 - d7 < d) {
                    d5 = d + d7;
                }
                if (d6 + d8 > d4) {
                    d6 = d4 - d8;
                }
                if (d6 - d8 < d3) {
                    d6 = d3 + d8;
                }
            }
            this.setX(visualItem, this.referrer, d5);
            this.setY(visualItem, this.referrer, d6);
        }
    }

    public void reset() {
        Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            ForceItem forceItem = (ForceItem)visualItem.get(FORCEITEM);
            if (forceItem == null) continue;
            forceItem.location[0] = (float)visualItem.getEndX();
            forceItem.location[1] = (float)visualItem.getEndY();
            forceItem.force[1] = 0.0f;
            forceItem.force[0] = 0.0f;
            forceItem.velocity[1] = 0.0f;
            forceItem.velocity[0] = 0.0f;
        }
        this.m_lasttime = -1L;
    }

    protected void initSimulator(ForceSimulator forceSimulator) {
        Object object;
        VisualItem visualItem;
        TupleSet tupleSet = this.m_vis.getGroup(this.m_nodeGroup);
        if (tupleSet == null) {
            return;
        }
        try {
            tupleSet.addColumns(FORCEITEM_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        float f = this.referrer == null ? 0.0f : (float)this.referrer.getX();
        float f2 = this.referrer == null ? 0.0f : (float)this.referrer.getY();
        f = Float.isNaN(f) ? 0.0f : f;
        f2 = Float.isNaN(f2) ? 0.0f : f2;
        Iterator iterator = this.m_vis.visibleItems(this.m_nodeGroup);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            object = (ForceItem)visualItem.get(FORCEITEM);
            ((ForceItem)object).mass = this.getMassValue(visualItem);
            double d = visualItem.getEndX();
            double d2 = visualItem.getEndY();
            ((ForceItem)object).location[0] = Double.isNaN(d) ? f : (float)d;
            ((ForceItem)object).location[1] = Double.isNaN(d2) ? f2 : (float)d2;
            forceSimulator.addItem((ForceItem)object);
        }
        if (this.m_edgeGroup != null) {
            iterator = this.m_vis.visibleItems(this.m_edgeGroup);
            while (iterator.hasNext()) {
                visualItem = (EdgeItem)iterator.next();
                object = visualItem.getSourceItem();
                ForceItem forceItem = (ForceItem)object.get(FORCEITEM);
                NodeItem nodeItem = visualItem.getTargetItem();
                ForceItem forceItem2 = (ForceItem)nodeItem.get(FORCEITEM);
                float f3 = this.getSpringCoefficient((EdgeItem)visualItem);
                float f4 = this.getSpringLength((EdgeItem)visualItem);
                forceSimulator.addSpring(forceItem, forceItem2, f3 >= 0.0f ? f3 : -1.0f, f4 >= 0.0f ? f4 : -1.0f);
            }
        }
    }

    protected float getMassValue(VisualItem visualItem) {
        return 1.0f;
    }

    protected float getSpringLength(EdgeItem edgeItem) {
        return -1.0f;
    }

    protected float getSpringCoefficient(EdgeItem edgeItem) {
        return -1.0f;
    }

    public VisualItem getReferrer() {
        return this.referrer;
    }

    public void setReferrer(VisualItem visualItem) {
        this.referrer = visualItem;
    }

    static {
        FORCEITEM_SCHEMA.addColumn(FORCEITEM, ForceItem.class, new ForceItem());
    }
}

