/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.util.Iterator;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.NodeItem;

public class BalloonTreeLayout
extends TreeLayout {
    private int m_minRadius = 2;
    public static final String PARAMS = "_balloonTreeLayoutParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public BalloonTreeLayout(String string) {
        this(string, 2);
    }

    public BalloonTreeLayout(String string, int n) {
        super(string);
        this.m_minRadius = n;
    }

    public int getMinRadius() {
        return this.m_minRadius;
    }

    public void setMinRadius(int n) {
        this.m_minRadius = n;
    }

    @Override
    public void run(double d) {
        Graph graph = (Graph)this.m_vis.getGroup(this.m_group);
        this.initSchema(graph.getNodes());
        Point2D point2D = this.getLayoutAnchor();
        NodeItem nodeItem = this.getLayoutRoot();
        this.layout(nodeItem, point2D.getX(), point2D.getY());
    }

    private void layout(NodeItem nodeItem, double d, double d2) {
        this.firstWalk(nodeItem);
        this.secondWalk(nodeItem, null, d, d2, 1.0, 0.0);
    }

    private void firstWalk(NodeItem nodeItem) {
        Params params = this.getParams(nodeItem);
        params.d = 0;
        double d = 0.0;
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            if (!nodeItem2.isVisible()) continue;
            this.firstWalk(nodeItem2);
            Params params2 = this.getParams(nodeItem2);
            params.d = Math.max(params.d, params2.r);
            params2.a = Math.atan((double)params2.r / (double)(params.d + params2.r));
            d += params2.a;
        }
        this.adjustChildren(params, d);
        this.setRadius(params);
    }

    private void adjustChildren(Params params, double d) {
        if (d > Math.PI) {
            params.c = Math.PI / d;
            params.f = 0.0;
        } else {
            params.c = 1.0;
            params.f = Math.PI - d;
        }
    }

    private void setRadius(Params params) {
        params.r = Math.max(params.d, this.m_minRadius) + 2 * params.d;
    }

    private void secondWalk(NodeItem nodeItem, NodeItem nodeItem2, double d, double d2, double d3, double d4) {
        this.setX(nodeItem, nodeItem2, d);
        this.setY(nodeItem, nodeItem2, d2);
        Params params = this.getParams(nodeItem);
        int n = 0;
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem3 = (NodeItem)iterator.next();
            if (!nodeItem3.isVisible()) continue;
            ++n;
        }
        double d5 = d3 * (double)params.d;
        double d6 = d4 + Math.PI;
        double d7 = n == 0 ? 0.0 : params.f / (double)n;
        double d8 = 0.0;
        iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem4 = (NodeItem)iterator.next();
            if (!nodeItem4.isVisible()) continue;
            Params params2 = this.getParams(nodeItem4);
            double d9 = params.c * params2.a;
            double d10 = (double)params.d * Math.tan(d9) / (1.0 - Math.tan(d9));
            double d11 = (d3 * d10 + d5) * Math.cos(d6 += d8 + d9 + d7);
            double d12 = (d3 * d10 + d5) * Math.sin(d6);
            d8 = d9;
            this.secondWalk(nodeItem4, nodeItem, d + d11, d2 + d12, d3 * params.c, d6);
        }
    }

    private void initSchema(TupleSet tupleSet) {
        try {
            tupleSet.addColumns(PARAMS_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Params getParams(NodeItem nodeItem) {
        Params params = (Params)nodeItem.get(PARAMS);
        if (params == null) {
            params = new Params();
            nodeItem.set(PARAMS, (Object)params);
        }
        return params;
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class);
    }

    public static class Params {
        public int d;
        public int r;
        public double rx;
        public double ry;
        public double a;
        public double c;
        public double f;
    }
}

