/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class CircleLayout
extends Layout {
    private double m_radius;

    public CircleLayout(String string) {
        super(string);
    }

    public CircleLayout(String string, double d) {
        super(string);
        this.m_radius = d;
    }

    public double getRadius() {
        return this.m_radius;
    }

    public void setRadius(double d) {
        this.m_radius = d;
    }

    @Override
    public void run(double d) {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        int n = tupleSet.getTupleCount();
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d2 = rectangle2D.getHeight();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getCenterX();
        double d5 = rectangle2D.getCenterY();
        double d6 = this.m_radius;
        if (d6 <= 0.0) {
            d6 = 0.45 * (d2 < d3 ? d2 : d3);
        }
        Iterator iterator = tupleSet.tuples();
        int n2 = 0;
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            double d7 = Math.PI * 2 * (double)n2 / (double)n;
            double d8 = Math.cos(d7) * d6 + d4;
            double d9 = Math.sin(d7) * d6 + d5;
            this.setX(visualItem, null, d8);
            this.setY(visualItem, null, d9);
            ++n2;
        }
    }
}

