/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.filter;

import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.GroupAction;
import prefuse.data.Graph;
import prefuse.data.expression.Predicate;
import prefuse.data.util.BreadthFirstIterator;
import prefuse.data.util.FilterIterator;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class GraphDistanceFilter
extends GroupAction {
    protected int m_distance;
    protected String m_sources;
    protected Predicate m_groupP;
    protected BreadthFirstIterator m_bfs;

    public GraphDistanceFilter(String string) {
        this(string, 1);
    }

    public GraphDistanceFilter(String string, int n) {
        this(string, Visualization.FOCUS_ITEMS, n);
    }

    public GraphDistanceFilter(String string, String string2, int n) {
        super(string);
        this.m_sources = string2;
        this.m_distance = n;
        this.m_groupP = new InGroupPredicate(PrefuseLib.getGroupName(string, Graph.NODES));
        this.m_bfs = new BreadthFirstIterator();
    }

    public int getDistance() {
        return this.m_distance;
    }

    public void setDistance(int n) {
        this.m_distance = n;
    }

    public String getSources() {
        return this.m_sources;
    }

    public void setSources(String string) {
        this.m_sources = string;
    }

    @Override
    public void run(double d) {
        VisualItem visualItem;
        Object object;
        Iterator iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            object.setDOI(-1.7976931348623157E308);
        }
        object = this.m_vis.getGroup(this.m_sources);
        FilterIterator filterIterator = new FilterIterator(object.tuples(), this.m_groupP);
        this.m_bfs.init(filterIterator, this.m_distance, 2);
        while (this.m_bfs.hasNext()) {
            visualItem = (VisualItem)this.m_bfs.next();
            int n = this.m_bfs.getDepth(visualItem);
            PrefuseLib.updateVisible(visualItem, true);
            visualItem.setDOI(-n);
            visualItem.setExpanded(n < this.m_distance);
        }
        iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            visualItem = (VisualItem)iterator.next();
            if (visualItem.getDOI() != -1.7976931348623157E308) continue;
            PrefuseLib.updateVisible(visualItem, false);
            visualItem.setExpanded(false);
        }
    }
}

