/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.action.distortion.Distortion;

public class FisheyeDistortion
extends Distortion {
    private double dx;
    private double dy;
    private double sz = 3.0;

    public FisheyeDistortion() {
        this(4.0);
    }

    public FisheyeDistortion(double d) {
        this(d, d);
    }

    public FisheyeDistortion(double d, double d2) {
        this.dx = d;
        this.dy = d2;
        this.m_distortX = this.dx > 0.0;
        this.m_distortY = this.dy > 0.0;
    }

    public double getXDistortionFactor() {
        return this.dx;
    }

    public void setXDistortionFactor(double d) {
        this.dx = d;
        this.m_distortX = this.dx > 0.0;
    }

    public double getYDistortionFactor() {
        return this.dy;
    }

    public void setYDistortionFactor(double d) {
        this.dy = d;
        this.m_distortY = this.dy > 0.0;
    }

    @Override
    protected double distortX(double d, Point2D point2D, Rectangle2D rectangle2D) {
        return this.fisheye(d, point2D.getX(), this.dx, rectangle2D.getMinX(), rectangle2D.getMaxX());
    }

    @Override
    protected double distortY(double d, Point2D point2D, Rectangle2D rectangle2D) {
        return this.fisheye(d, point2D.getY(), this.dy, rectangle2D.getMinY(), rectangle2D.getMaxY());
    }

    @Override
    protected double distortSize(Rectangle2D rectangle2D, double d, double d2, Point2D point2D, Rectangle2D rectangle2D2) {
        double d3;
        double d4;
        double d5;
        double d6;
        if (!this.m_distortX && !this.m_distortY) {
            return 1.0;
        }
        double d7 = 1.0;
        double d8 = 1.0;
        if (this.m_distortX) {
            d6 = point2D.getX();
            d5 = rectangle2D.getMinX();
            d4 = rectangle2D.getMaxX();
            double d9 = d3 = Math.abs(d5 - d6) > Math.abs(d4 - d6) ? d5 : d4;
            if (d3 < rectangle2D2.getMinX() || d3 > rectangle2D2.getMaxX()) {
                d3 = d3 == d5 ? d4 : d5;
            }
            d7 = this.fisheye(d3, d6, this.dx, rectangle2D2.getMinX(), rectangle2D2.getMaxX());
            d7 = Math.abs(d - d7) / rectangle2D.getWidth();
        }
        if (this.m_distortY) {
            d6 = point2D.getY();
            d5 = rectangle2D.getMinY();
            d4 = rectangle2D.getMaxY();
            double d10 = d3 = Math.abs(d5 - d6) > Math.abs(d4 - d6) ? d5 : d4;
            if (d3 < rectangle2D2.getMinY() || d3 > rectangle2D2.getMaxY()) {
                d3 = d3 == d5 ? d4 : d5;
            }
            d8 = this.fisheye(d3, d6, this.dy, rectangle2D2.getMinY(), rectangle2D2.getMaxY());
            d8 = Math.abs(d2 - d8) / rectangle2D.getHeight();
        }
        double d11 = !this.m_distortY ? d7 : (d6 = !this.m_distortX ? d8 : Math.min(d7, d8));
        if (Double.isInfinite(d6) || Double.isNaN(d6)) {
            return 1.0;
        }
        return this.sz * d6;
    }

    private double fisheye(double d, double d2, double d3, double d4, double d5) {
        if (d3 != 0.0) {
            double d6;
            boolean bl = d < d2;
            double d7 = d6 = bl ? d2 - d4 : d5 - d2;
            if (d6 == 0.0) {
                d6 = d5 - d4;
            }
            double d8 = Math.abs(d - d2) / d6;
            d8 = (d3 + 1.0) / (d3 + 1.0 / d8);
            return (double)(bl ? -1 : 1) * d6 * d8 + d2;
        }
        return d;
    }
}

