/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.util.StrokeLib;
import prefuse.visual.VisualItem;

public class StrokeAction
extends EncoderAction {
    protected BasicStroke defaultStroke = StrokeLib.getStroke(1.0f);

    public StrokeAction() {
    }

    public StrokeAction(String string) {
        super(string);
    }

    public StrokeAction(String string, BasicStroke basicStroke) {
        super(string);
        this.defaultStroke = basicStroke;
    }

    public void setDefaultStroke(BasicStroke basicStroke) {
        this.defaultStroke = basicStroke;
    }

    public BasicStroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void add(Predicate predicate, BasicStroke basicStroke) {
        super.add(predicate, basicStroke);
    }

    public void add(String string, BasicStroke basicStroke) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        this.add(predicate, basicStroke);
    }

    public void add(Predicate predicate, StrokeAction strokeAction) {
        super.add(predicate, strokeAction);
    }

    public void add(String string, StrokeAction strokeAction) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        super.add(predicate, strokeAction);
    }

    @Override
    public void process(VisualItem visualItem, double d) {
        visualItem.setStroke(this.getStroke(visualItem));
    }

    public BasicStroke getStroke(VisualItem visualItem) {
        Object object = this.lookup(visualItem);
        if (object != null) {
            if (object instanceof StrokeAction) {
                return ((StrokeAction)object).getStroke(visualItem);
            }
            if (object instanceof Stroke) {
                return (BasicStroke)object;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.defaultStroke;
    }
}

