/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action;

import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ItemAction;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.ObjectLiteral;
import prefuse.data.expression.Predicate;
import prefuse.util.PredicateChain;
import prefuse.visual.VisualItem;

public abstract class EncoderAction
extends ItemAction {
    private PredicateChain m_chain = null;

    public EncoderAction() {
    }

    public EncoderAction(Visualization visualization) {
        super(visualization);
    }

    public EncoderAction(String string) {
        super(string);
    }

    public EncoderAction(String string, Predicate predicate) {
        super(string, predicate);
    }

    public EncoderAction(Visualization visualization, String string) {
        super(visualization, string);
    }

    public EncoderAction(Visualization visualization, String string, Predicate predicate) {
        super(visualization, string, predicate);
    }

    protected void add(Predicate predicate, Object object) {
        if (this.m_chain == null) {
            this.m_chain = new PredicateChain();
        }
        if (object instanceof Action) {
            ((Action)object).setVisualization(this.m_vis);
        }
        this.m_chain.add(predicate, object);
    }

    protected Object lookup(VisualItem visualItem) {
        return this.m_chain == null ? null : this.m_chain.get(visualItem);
    }

    public void clear() {
        if (this.m_chain != null) {
            this.m_chain.clear();
        }
    }

    public boolean remove(Predicate predicate) {
        return this.m_chain != null ? this.m_chain.remove(predicate) : false;
    }

    @Override
    public void setVisualization(Visualization visualization) {
        super.setVisualization(visualization);
        if (this.m_chain != null) {
            this.m_chain.getExpression().visit(new SetVisualizationVisitor());
        }
    }

    @Override
    public void run(double d) {
        this.setup();
        if (this.m_chain != null) {
            this.m_chain.getExpression().visit(SetupVisitor.getInstance());
        }
        super.run(d);
        if (this.m_chain != null) {
            this.m_chain.getExpression().visit(FinishVisitor.getInstance());
        }
        this.finish();
    }

    protected void setup() {
    }

    protected void finish() {
    }

    private static class FinishVisitor
    extends ActionVisitor {
        private static FinishVisitor s_instance;

        private FinishVisitor() {
        }

        public static FinishVisitor getInstance() {
            if (s_instance == null) {
                s_instance = new FinishVisitor();
            }
            return s_instance;
        }

        @Override
        public void visitAction(Action action) {
            if (action instanceof EncoderAction) {
                ((EncoderAction)action).setup();
            }
        }
    }

    private static class SetupVisitor
    extends ActionVisitor {
        private static SetupVisitor s_instance;

        private SetupVisitor() {
        }

        public static SetupVisitor getInstance() {
            if (s_instance == null) {
                s_instance = new SetupVisitor();
            }
            return s_instance;
        }

        @Override
        public void visitAction(Action action) {
            if (action instanceof EncoderAction) {
                ((EncoderAction)action).setup();
            }
        }
    }

    private class SetVisualizationVisitor
    extends ActionVisitor {
        private SetVisualizationVisitor() {
        }

        @Override
        public void visitAction(Action action) {
            action.setVisualization(EncoderAction.this.m_vis);
        }
    }

    private static abstract class ActionVisitor
    implements ExpressionVisitor {
        private ActionVisitor() {
        }

        @Override
        public void visitExpression(Expression expression) {
            Object object;
            if (expression instanceof ObjectLiteral && (object = expression.get(null)) instanceof Action) {
                this.visitAction((Action)object);
            }
        }

        public abstract void visitAction(Action var1);

        @Override
        public void down() {
        }

        @Override
        public void up() {
        }
    }
}

