/*
 * Decompiled with CFR 0.152.
 */
package prefuse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import prefuse.Visualization;
import prefuse.activity.Activity;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.render.Renderer;
import prefuse.util.ColorLib;
import prefuse.util.StringLib;
import prefuse.util.UpdateListener;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.display.BackgroundPainter;
import prefuse.util.display.Clip;
import prefuse.util.display.DebugStatsPainter;
import prefuse.util.display.ExportDisplayAction;
import prefuse.util.display.ItemBoundsListener;
import prefuse.util.display.PaintListener;
import prefuse.util.display.RenderingQueue;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.VisiblePredicate;
import prefuse.visual.sort.ItemSorter;

public class Display
extends JComponent {
    private static final Logger s_logger = Logger.getLogger(Display.class.getName());
    protected Visualization m_vis;
    protected AndPredicate m_predicate = new AndPredicate();
    protected CopyOnWriteArrayList m_controls = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList m_painters;
    protected CopyOnWriteArrayList m_bounders;
    protected BufferedImage m_offscreen;
    protected Clip m_clip = new Clip();
    protected Clip m_screen = new Clip();
    protected Clip m_bounds = new Clip();
    protected Rectangle2D m_rclip = new Rectangle2D.Double();
    protected boolean m_damageRedraw = true;
    protected boolean m_highQuality = false;
    protected BackgroundPainter m_bgpainter = null;
    protected RenderingQueue m_queue = new RenderingQueue();
    protected int m_visibleCount = 0;
    protected AffineTransform m_transform = new AffineTransform();
    protected AffineTransform m_itransform = new AffineTransform();
    protected TransformActivity m_transact = new TransformActivity();
    protected Point2D m_tmpPoint = new Point2D.Double();
    protected double frameRate;
    protected int nframes = 0;
    private int sampleInterval = 10;
    private long mark = -1L;
    protected JToolTip m_customToolTip = null;
    private JTextComponent m_editor;
    private boolean m_editing;
    private VisualItem m_editItem;
    private String m_editAttribute;

    public Display() {
        this(null);
    }

    public Display(Visualization visualization) {
        this(visualization, (Predicate)null);
    }

    public Display(Visualization visualization, String string) {
        this(visualization, (Predicate)ExpressionParser.parse(string, true));
    }

    public Display(Visualization visualization, Predicate predicate) {
        this.setDoubleBuffered(false);
        this.setBackground(Color.WHITE);
        this.m_editing = false;
        this.m_editor = new JTextField();
        this.m_editor.setBorder(null);
        this.m_editor.setVisible(false);
        this.add(this.m_editor);
        InputEventCapturer inputEventCapturer = new InputEventCapturer();
        this.addMouseListener(inputEventCapturer);
        this.addMouseMotionListener(inputEventCapturer);
        this.addMouseWheelListener(inputEventCapturer);
        this.addKeyListener(inputEventCapturer);
        this.registerDefaultCommands();
        this.m_predicate.addExpressionListener(new UpdateListener(){

            @Override
            public void update(Object object) {
                Display.this.damageReport();
            }
        });
        this.setVisualization(visualization);
        this.setPredicate(predicate);
        this.setSize(400, 400);
    }

    public void reset() {
        this.m_offscreen = null;
        this.m_queue.clean();
    }

    protected void registerDefaultCommands() {
        this.registerKeyboardAction(new ActionListener(){
            private PaintListener m_debug = null;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.m_debug == null) {
                    this.m_debug = new DebugStatsPainter();
                    Display.this.addPaintListener(this.m_debug);
                } else {
                    Display.this.removePaintListener(this.m_debug);
                    this.m_debug = null;
                }
                Display.this.repaint();
            }
        }, "debug info", KeyStroke.getKeyStroke("ctrl D"), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Display.this.setHighQuality(!Display.this.isHighQuality());
                Display.this.repaint();
            }
        }, "toggle high-quality drawing", KeyStroke.getKeyStroke("ctrl H"), 0);
        try {
            this.registerKeyboardAction(new ExportDisplayAction(this), "export display", KeyStroke.getKeyStroke("ctrl E"), 0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void setSize(int n, int n2) {
        this.m_offscreen = null;
        this.setPreferredSize(new Dimension(n, n2));
        super.setSize(n, n2);
    }

    @Override
    public void setSize(Dimension dimension) {
        this.m_offscreen = null;
        this.setPreferredSize(dimension);
        super.setSize(dimension);
    }

    @Override
    public void invalidate() {
        this.damageReport();
        super.invalidate();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_offscreen = null;
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.m_editor.setFont(font);
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setHighQuality(boolean bl) {
        if (this.m_highQuality != bl) {
            this.damageReport();
        }
        this.m_highQuality = bl;
    }

    public boolean isHighQuality() {
        return this.m_highQuality;
    }

    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization visualization) {
        if (this.m_vis == visualization) {
            return;
        }
        if (this.m_vis != null) {
            this.m_vis.removeDisplay(this);
        }
        this.m_vis = visualization;
        if (this.m_vis != null) {
            this.m_vis.addDisplay(this);
        }
    }

    public Predicate getPredicate() {
        if (this.m_predicate.size() == 1) {
            return BooleanLiteral.TRUE;
        }
        return this.m_predicate.get(0);
    }

    public void setPredicate(String string) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string, true);
        this.setPredicate(predicate);
    }

    public synchronized void setPredicate(Predicate predicate) {
        if (predicate == null) {
            this.m_predicate.set(VisiblePredicate.TRUE);
        } else {
            this.m_predicate.set(new Predicate[]{predicate, VisiblePredicate.TRUE});
        }
    }

    public int getVisibleItemCount() {
        return this.m_visibleCount;
    }

    public ItemSorter getItemSorter() {
        return this.m_queue.sort;
    }

    public synchronized void setItemSorter(ItemSorter itemSorter) {
        this.damageReport();
        this.m_queue.sort = itemSorter;
    }

    public synchronized void setBackgroundImage(Image image, boolean bl, boolean bl2) {
        BackgroundPainter backgroundPainter = null;
        if (image != null) {
            backgroundPainter = new BackgroundPainter(image, bl, bl2);
        }
        this.setBackgroundPainter(backgroundPainter);
    }

    public synchronized void setBackgroundImage(String string, boolean bl, boolean bl2) {
        BackgroundPainter backgroundPainter = null;
        if (string != null) {
            backgroundPainter = new BackgroundPainter(string, bl, bl2);
        }
        this.setBackgroundPainter(backgroundPainter);
    }

    private void setBackgroundPainter(BackgroundPainter backgroundPainter) {
        if (this.m_bgpainter != null) {
            this.removePaintListener(this.m_bgpainter);
        }
        this.m_bgpainter = backgroundPainter;
        if (backgroundPainter != null) {
            this.addPaintListener(backgroundPainter);
        }
    }

    @Override
    public JToolTip createToolTip() {
        if (this.m_customToolTip == null) {
            return super.createToolTip();
        }
        return this.m_customToolTip;
    }

    public void setCustomToolTip(JToolTip jToolTip) {
        this.m_customToolTip = jToolTip;
    }

    public JToolTip getCustomToolTip() {
        return this.m_customToolTip;
    }

    public synchronized boolean isDamageRedraw() {
        return this.m_damageRedraw;
    }

    public synchronized void setDamageRedraw(boolean bl) {
        this.m_damageRedraw = bl;
        this.m_clip.invalidate();
    }

    public synchronized void damageReport(Rectangle2D rectangle2D) {
        if (this.m_damageRedraw) {
            this.m_clip.union(rectangle2D);
        }
    }

    public synchronized void damageReport() {
        this.m_clip.invalidate();
    }

    public synchronized void clearDamage() {
        if (this.m_damageRedraw) {
            this.m_clip.reset();
        }
    }

    public synchronized Rectangle2D getItemBounds() {
        return this.getItemBounds(new Rectangle2D.Double());
    }

    public synchronized Rectangle2D getItemBounds(Rectangle2D rectangle2D) {
        rectangle2D.setFrameFromDiagonal(this.m_bounds.getMinX(), this.m_bounds.getMinY(), this.m_bounds.getMaxX(), this.m_bounds.getMaxY());
        return rectangle2D;
    }

    public BufferedImage getOffscreenBuffer() {
        return this.m_offscreen;
    }

    protected BufferedImage getNewOffscreenBuffer(int n, int n2) {
        BufferedImage bufferedImage = null;
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                bufferedImage = (BufferedImage)this.createImage(n, n2);
            }
            catch (Exception exception) {
                bufferedImage = null;
            }
        }
        if (bufferedImage == null) {
            return new BufferedImage(n, n2, 1);
        }
        return bufferedImage;
    }

    public boolean saveImage(OutputStream outputStream, String string, double d) {
        try {
            Dimension dimension = new Dimension((int)(d * (double)this.getWidth()), (int)(d * (double)this.getHeight()));
            BufferedImage bufferedImage = this.getNewOffscreenBuffer(dimension.width, dimension.height);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
            this.zoom(double_, d);
            boolean bl = this.isHighQuality();
            this.setHighQuality(true);
            this.paintDisplay(graphics2D, dimension);
            this.setHighQuality(bl);
            this.zoom(double_, 1.0 / d);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBufferToScreen(Graphics graphics) {
        Display display = this;
        synchronized (display) {
            graphics.drawImage(this.m_offscreen, 0, 0, null);
        }
    }

    public void repaintImmediate() {
        Graphics graphics = this.getGraphics();
        if (graphics != null && this.m_offscreen != null) {
            this.paintBufferToScreen(graphics);
        }
    }

    protected void prepareGraphics(Graphics2D graphics2D) {
        if (this.m_transform != null) {
            graphics2D.transform(this.m_transform);
        }
        this.setRenderingHints(graphics2D);
    }

    protected void setRenderingHints(Graphics2D graphics2D) {
        if (this.m_highQuality) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.m_offscreen == null) {
            this.m_offscreen = this.getNewOffscreenBuffer(this.getWidth(), this.getHeight());
            this.damageReport();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Graphics2D graphics2D2 = (Graphics2D)this.m_offscreen.getGraphics();
        this.paintDisplay(graphics2D2, this.getSize());
        this.paintBufferToScreen(graphics2D);
        this.firePostPaint(graphics2D);
        graphics2D2.dispose();
        ++this.nframes;
        if (this.mark < 0L) {
            this.mark = System.currentTimeMillis();
            this.nframes = 0;
        } else if (this.nframes == this.sampleInterval) {
            long l = System.currentTimeMillis();
            this.frameRate = 1000.0 * (double)this.nframes / (double)(l - this.mark);
            this.mark = l;
            this.nframes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDisplay(Graphics2D graphics2D, Dimension dimension) {
        Visualization visualization = this.m_vis;
        synchronized (visualization) {
            Display display = this;
            synchronized (display) {
                if (this.m_clip.isEmpty()) {
                    return;
                }
                this.m_screen.setClip(0.0, 0.0, dimension.width + 1, dimension.height + 1);
                this.m_screen.transform(this.m_itransform);
                double d = 1.0 + 1.0 / this.getScale();
                if (this.m_damageRedraw) {
                    if (this.m_clip.isInvalid()) {
                        this.m_clip.setClip(this.m_screen);
                    } else {
                        this.m_clip.intersection(this.m_screen);
                    }
                    this.m_clip.expand(d);
                    this.prepareGraphics(graphics2D);
                    this.m_rclip.setFrameFromDiagonal(this.m_clip.getMinX(), this.m_clip.getMinY(), this.m_clip.getMaxX(), this.m_clip.getMaxY());
                    graphics2D.setClip(this.m_rclip);
                    this.m_rclip.setFrameFromDiagonal(this.m_clip.getMinX() - d, this.m_clip.getMinY() - d, this.m_clip.getMaxX() + d, this.m_clip.getMaxY() + d);
                } else {
                    this.m_rclip.setFrame(this.m_screen.getMinX(), this.m_screen.getMinY(), this.m_screen.getWidth(), this.m_screen.getHeight());
                    this.m_clip.setClip(this.m_screen);
                    this.prepareGraphics(graphics2D);
                }
                this.clearRegion(graphics2D, this.m_rclip);
                this.getItemBounds(this.m_rclip);
                this.m_bounds.reset();
                this.m_queue.clear();
                Iterator iterator = this.m_vis.items(this.m_predicate);
                this.m_visibleCount = 0;
                while (iterator.hasNext()) {
                    VisualItem visualItem = (VisualItem)iterator.next();
                    Rectangle2D rectangle2D = visualItem.getBounds();
                    this.m_bounds.union(rectangle2D);
                    if (this.m_clip.intersects(rectangle2D, d)) {
                        this.m_queue.addToRenderQueue(visualItem);
                    }
                    if (visualItem.isInteractive()) {
                        this.m_queue.addToPickingQueue(visualItem);
                    }
                    ++this.m_visibleCount;
                }
                this.m_queue.sortRenderQueue();
                for (int i = 0; i < this.m_queue.rsize; ++i) {
                    this.m_queue.ritems[i].render(graphics2D);
                }
                if (this.m_damageRedraw) {
                    this.m_clip.reset();
                }
                this.checkItemBoundsChanged(this.m_rclip);
            }
        }
    }

    public void renderImmediate(VisualItem visualItem) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        this.prepareGraphics(graphics2D);
        visualItem.render(graphics2D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void printComponent(Graphics graphics) {
        boolean bl = this.m_highQuality;
        try {
            this.m_highQuality = true;
            this.paintDisplay((Graphics2D)graphics, this.getSize());
        }
        finally {
            this.m_highQuality = bl;
        }
    }

    protected void clearRegion(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        graphics2D.setColor(this.getBackground());
        graphics2D.fill(rectangle2D);
        this.firePrePaint(graphics2D);
    }

    public synchronized void setTransform(AffineTransform affineTransform) throws NoninvertibleTransformException {
        this.damageReport();
        this.m_transform = affineTransform;
        this.m_itransform = this.m_transform.createInverse();
    }

    public AffineTransform getTransform() {
        return this.m_transform;
    }

    public AffineTransform getInverseTransform() {
        return this.m_itransform;
    }

    public Point2D getAbsoluteCoordinate(Point2D point2D, Point2D point2D2) {
        return this.m_itransform.transform(point2D, point2D2);
    }

    public double getScale() {
        return this.m_transform.getScaleX();
    }

    public double getDisplayX() {
        return -this.m_transform.getTranslateX();
    }

    public double getDisplayY() {
        return -this.m_transform.getTranslateY();
    }

    public synchronized void pan(double d, double d2) {
        this.m_tmpPoint.setLocation(d, d2);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        double d3 = this.m_tmpPoint.getX();
        double d4 = this.m_tmpPoint.getY();
        this.m_tmpPoint.setLocation(0.0, 0.0);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        this.panAbs(d3 -= this.m_tmpPoint.getX(), d4 -= this.m_tmpPoint.getY());
    }

    public synchronized void panAbs(double d, double d2) {
        this.damageReport();
        this.m_transform.translate(d, d2);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void panTo(Point2D point2D) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.panToAbs(this.m_tmpPoint);
    }

    public synchronized void panToAbs(Point2D point2D) {
        double d = this.m_transform.getScaleX();
        double d2 = this.m_transform.getScaleY();
        double d3 = point2D.getX();
        d3 = Double.isNaN(d3) ? 0.0 : d3;
        double d4 = point2D.getY();
        d4 = Double.isNaN(d4) ? 0.0 : d4;
        d3 = (double)this.getWidth() / (2.0 * d) - d3;
        d4 = (double)this.getHeight() / (2.0 * d2) - d4;
        double d5 = d3 - this.m_transform.getTranslateX() / d;
        double d6 = d4 - this.m_transform.getTranslateY() / d2;
        this.damageReport();
        this.m_transform.translate(d5, d6);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void zoom(Point2D point2D, double d) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.zoomAbs(this.m_tmpPoint, d);
    }

    public synchronized void zoomAbs(Point2D point2D, double d) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        this.damageReport();
        this.m_transform.translate(d2, d3);
        this.m_transform.scale(d, d);
        this.m_transform.translate(-d2, -d3);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void rotate(Point2D point2D, double d) {
        this.m_itransform.transform(point2D, this.m_tmpPoint);
        this.rotateAbs(this.m_tmpPoint, d);
    }

    public synchronized void rotateAbs(Point2D point2D, double d) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        this.damageReport();
        this.m_transform.translate(d2, d3);
        this.m_transform.rotate(d);
        this.m_transform.translate(-d2, -d3);
        try {
            this.m_itransform = this.m_transform.createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void animatePan(double d, double d2, long l) {
        double d3 = d / this.m_transform.getScaleX();
        double d4 = d2 / this.m_transform.getScaleY();
        this.animatePanAbs(d3, d4, l);
    }

    public synchronized void animatePanAbs(double d, double d2, long l) {
        this.m_transact.pan(d, d2, l);
    }

    public synchronized void animatePanTo(Point2D point2D, long l) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animatePanToAbs(double_, l);
    }

    public synchronized void animatePanToAbs(Point2D point2D, long l) {
        this.m_tmpPoint.setLocation(0.0, 0.0);
        this.m_itransform.transform(this.m_tmpPoint, this.m_tmpPoint);
        double d = point2D.getX();
        d = Double.isNaN(d) ? 0.0 : d;
        double d2 = point2D.getY();
        d2 = Double.isNaN(d2) ? 0.0 : d2;
        double d3 = (double)this.getWidth() / (2.0 * this.m_transform.getScaleX());
        double d4 = (double)this.getHeight() / (2.0 * this.m_transform.getScaleY());
        double d5 = d3 - d + this.m_tmpPoint.getX();
        double d6 = d4 - d2 + this.m_tmpPoint.getY();
        this.animatePanAbs(d5, d6, l);
    }

    public synchronized void animateZoom(Point2D point2D, double d, long l) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animateZoomAbs(double_, d, l);
    }

    public synchronized void animateZoomAbs(Point2D point2D, double d, long l) {
        this.m_transact.zoom(point2D, d, l);
    }

    public synchronized void animatePanAndZoomTo(Point2D point2D, double d, long l) {
        Point2D.Double double_ = new Point2D.Double();
        this.m_itransform.transform(point2D, double_);
        this.animatePanAndZoomToAbs(double_, d, l);
    }

    public synchronized void animatePanAndZoomToAbs(Point2D point2D, double d, long l) {
        this.m_transact.panAndZoom(point2D, d, l);
    }

    public boolean isTranformInProgress() {
        return this.m_transact.isRunning();
    }

    public void addPaintListener(PaintListener paintListener) {
        if (this.m_painters == null) {
            this.m_painters = new CopyOnWriteArrayList();
        }
        this.m_painters.add(paintListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.m_painters.remove(paintListener);
    }

    protected void firePrePaint(Graphics2D graphics2D) {
        if (this.m_painters != null && this.m_painters.size() > 0) {
            Object[] objectArray = this.m_painters.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    ((PaintListener)objectArray[i]).prePaint(this, graphics2D);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by PaintListener: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }
    }

    protected void firePostPaint(Graphics2D graphics2D) {
        if (this.m_painters != null && this.m_painters.size() > 0) {
            Object[] objectArray = this.m_painters.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    ((PaintListener)objectArray[i]).postPaint(this, graphics2D);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by PaintListener: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }
    }

    public void addItemBoundsListener(ItemBoundsListener itemBoundsListener) {
        if (this.m_bounders == null) {
            this.m_bounders = new CopyOnWriteArrayList();
        }
        this.m_bounders.add(itemBoundsListener);
    }

    public void removeItemBoundsListener(ItemBoundsListener itemBoundsListener) {
        this.m_bounders.remove(itemBoundsListener);
    }

    protected void checkItemBoundsChanged(Rectangle2D rectangle2D) {
        if (this.m_bounds.equals(rectangle2D)) {
            return;
        }
        if (this.m_bounders != null && this.m_bounders.size() > 0) {
            Object[] objectArray = this.m_bounders.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    ((ItemBoundsListener)objectArray[i]).itemBoundsChanged(this);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by ItemBoundsListener: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }
    }

    public void addControlListener(Control control) {
        this.m_controls.add(control);
    }

    public void removeControlListener(Control control) {
        this.m_controls.remove(control);
    }

    public synchronized VisualItem findItem(Point point) {
        Point point2;
        Point2D point2D = point2 = this.m_itransform == null ? point : this.m_itransform.transform(point, this.m_tmpPoint);
        if (!this.m_queue.psorted) {
            this.m_queue.sortPickingQueue();
        }
        int n = this.m_queue.psize;
        while (--n >= 0) {
            Renderer renderer;
            VisualItem visualItem = this.m_queue.pitems[n];
            if (!visualItem.isValid() || (renderer = visualItem.getRenderer()) == null || !visualItem.isInteractive() || !renderer.locatePoint(point2, visualItem)) continue;
            return visualItem;
        }
        return null;
    }

    public JTextComponent getTextEditor() {
        return this.m_editor;
    }

    public void setTextEditor(JTextComponent jTextComponent) {
        this.remove(this.m_editor);
        this.m_editor = jTextComponent;
        this.add((Component)this.m_editor, 1);
    }

    public void editText(VisualItem visualItem, String string) {
        if (this.m_editing) {
            this.stopEditing();
        }
        Rectangle2D rectangle2D = visualItem.getBounds();
        Rectangle rectangle = this.m_transform.createTransformedShape(rectangle2D).getBounds();
        if (this.m_editor instanceof JTextArea) {
            rectangle.y -= 2;
            rectangle.width += 22;
            rectangle.height += 2;
        } else {
            rectangle.x += 3;
            ++rectangle.y;
            rectangle.width -= 5;
            rectangle.height -= 2;
        }
        Font font = this.getFont();
        int n = (int)Math.round((double)font.getSize() * this.m_transform.getScaleX());
        Font font2 = new Font(font.getFontName(), font.getStyle(), n);
        this.m_editor.setFont(font2);
        this.editText(visualItem, string, rectangle);
    }

    public void editText(VisualItem visualItem, String string, Rectangle rectangle) {
        if (this.m_editing) {
            this.stopEditing();
        }
        String string2 = visualItem.getString(string);
        this.m_editItem = visualItem;
        this.m_editAttribute = string;
        Color color = ColorLib.getColor(visualItem.getTextColor());
        Color color2 = ColorLib.getColor(visualItem.getFillColor());
        this.m_editor.setForeground(color);
        this.m_editor.setBackground(color2);
        this.editText(string2, rectangle);
    }

    public void editText(String string, Rectangle rectangle) {
        if (this.m_editing) {
            this.stopEditing();
        }
        this.m_editing = true;
        this.m_editor.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.m_editor.setText(string);
        this.m_editor.setVisible(true);
        this.m_editor.setCaretPosition(string.length());
        this.m_editor.requestFocus();
    }

    public void stopEditing() {
        this.m_editor.setVisible(false);
        if (this.m_editItem != null) {
            String string = this.m_editor.getText();
            this.m_editItem.set(this.m_editAttribute, (Object)string);
            this.m_editItem = null;
            this.m_editAttribute = null;
            this.m_editor.setBackground(null);
            this.m_editor.setForeground(null);
        }
        this.m_editing = false;
    }

    public class InputEventCapturer
    implements MouseMotionListener,
    MouseWheelListener,
    MouseListener,
    KeyListener {
        private VisualItem activeItem = null;
        private boolean mouseDown = false;

        private boolean validityCheck() {
            if (this.activeItem.isValid()) {
                return true;
            }
            this.activeItem = null;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemDragged(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMouseDragged(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                boolean bl = false;
                VisualItem visualItem = Display.this.findItem(mouseEvent.getPoint());
                if (this.activeItem != null && this.activeItem != visualItem) {
                    if (this.validityCheck()) {
                        this.fireItemExited(this.activeItem, mouseEvent);
                    }
                    bl = true;
                }
                if (visualItem != null && visualItem != this.activeItem) {
                    this.fireItemEntered(visualItem, mouseEvent);
                    bl = true;
                }
                this.activeItem = visualItem;
                if (bl) {
                    return;
                }
                if (visualItem != null && visualItem == this.activeItem) {
                    this.fireItemMoved(visualItem, mouseEvent);
                }
                if (visualItem == null) {
                    this.fireMouseMoved(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemWheelMoved(this.activeItem, mouseWheelEvent);
                    }
                } else {
                    this.fireMouseWheelMoved(mouseWheelEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemClicked(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMouseClicked(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                this.mouseDown = true;
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemPressed(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMousePressed(mouseEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemReleased(this.activeItem, mouseEvent);
                    }
                } else {
                    this.fireMouseReleased(mouseEvent);
                }
                if (this.activeItem != null && this.mouseDown && this.isOffComponent(mouseEvent)) {
                    this.fireItemExited(this.activeItem, mouseEvent);
                    this.activeItem = null;
                }
                this.mouseDown = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                this.fireMouseEntered(mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (!this.mouseDown && this.activeItem != null) {
                    this.fireItemExited(this.activeItem, mouseEvent);
                    this.activeItem = null;
                }
                this.fireMouseExited(mouseEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyPressed(this.activeItem, keyEvent);
                    }
                } else {
                    this.fireKeyPressed(keyEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyReleased(KeyEvent keyEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyReleased(this.activeItem, keyEvent);
                    }
                } else {
                    this.fireKeyReleased(keyEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyTyped(KeyEvent keyEvent) {
            Visualization visualization = Display.this.m_vis;
            synchronized (visualization) {
                if (this.activeItem != null) {
                    if (this.validityCheck()) {
                        this.fireItemKeyTyped(this.activeItem, keyEvent);
                    }
                } else {
                    this.fireKeyTyped(keyEvent);
                }
            }
        }

        private boolean isOffComponent(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            return n < 0 || n > Display.this.getWidth() || n2 < 0 || n2 > Display.this.getHeight();
        }

        private void fireItemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemDragged(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemMoved(VisualItem visualItem, MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemMoved(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemWheelMoved(VisualItem visualItem, MouseWheelEvent mouseWheelEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemWheelMoved(visualItem, mouseWheelEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemClicked(VisualItem visualItem, MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemClicked(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemPressed(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemReleased(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
            visualItem.setHover(true);
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemEntered(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemExited(VisualItem visualItem, MouseEvent mouseEvent) {
            if (visualItem.isValid()) {
                visualItem.setHover(false);
            }
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemExited(visualItem, mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemKeyPressed(VisualItem visualItem, KeyEvent keyEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            if (objectArray.length == 0) {
                return;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyPressed(visualItem, keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemKeyReleased(VisualItem visualItem, KeyEvent keyEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyReleased(visualItem, keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireItemKeyTyped(VisualItem visualItem, KeyEvent keyEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.itemKeyTyped(visualItem, keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMouseEntered(MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseEntered(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMouseExited(MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseExited(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMousePressed(MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mousePressed(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMouseReleased(MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseReleased(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMouseClicked(MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseClicked(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMouseDragged(MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseDragged(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMouseMoved(MouseEvent mouseEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseMoved(mouseEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.mouseWheelMoved(mouseWheelEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireKeyPressed(KeyEvent keyEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.keyPressed(keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireKeyReleased(KeyEvent keyEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.keyReleased(keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }

        private void fireKeyTyped(KeyEvent keyEvent) {
            Object[] objectArray = Display.this.m_controls.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Control control = (Control)objectArray[i];
                if (!control.isEnabled()) continue;
                try {
                    control.keyTyped(keyEvent);
                    continue;
                }
                catch (Exception exception) {
                    s_logger.warning("Exception thrown by Control: " + exception + "\n" + StringLib.getStackTrace(exception));
                }
            }
        }
    }

    private class TransformActivity
    extends Activity {
        private double[] src;
        private double[] dst;
        private AffineTransform m_at;

        public TransformActivity() {
            super(2000L, 20L, 0L);
            this.src = new double[6];
            this.dst = new double[6];
            this.m_at = new AffineTransform();
            this.setPacingFunction(new SlowInSlowOutPacer());
        }

        private AffineTransform getTransform() {
            if (this.isScheduled()) {
                this.m_at.setTransform(this.dst[0], this.dst[1], this.dst[2], this.dst[3], this.dst[4], this.dst[5]);
            } else {
                this.m_at.setTransform(Display.this.m_transform);
            }
            return this.m_at;
        }

        public void panAndZoom(Point2D point2D, double d, long l) {
            AffineTransform affineTransform = this.getTransform();
            this.cancel();
            this.setDuration(l);
            Display.this.m_tmpPoint.setLocation(0.0, 0.0);
            Display.this.m_itransform.transform(Display.this.m_tmpPoint, Display.this.m_tmpPoint);
            double d2 = point2D.getX();
            d2 = Double.isNaN(d2) ? 0.0 : d2;
            double d3 = point2D.getY();
            d3 = Double.isNaN(d3) ? 0.0 : d3;
            double d4 = (double)Display.this.getWidth() / (2.0 * Display.this.m_transform.getScaleX());
            double d5 = (double)Display.this.getHeight() / (2.0 * Display.this.m_transform.getScaleY());
            double d6 = d4 - d2 + Display.this.m_tmpPoint.getX();
            double d7 = d5 - d3 + Display.this.m_tmpPoint.getY();
            affineTransform.translate(d6, d7);
            affineTransform.translate(point2D.getX(), point2D.getY());
            affineTransform.scale(d, d);
            affineTransform.translate(-point2D.getX(), -point2D.getY());
            affineTransform.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.run();
        }

        public void pan(double d, double d2, long l) {
            AffineTransform affineTransform = this.getTransform();
            this.cancel();
            this.setDuration(l);
            affineTransform.translate(d, d2);
            affineTransform.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.run();
        }

        public void zoom(Point2D point2D, double d, long l) {
            AffineTransform affineTransform = this.getTransform();
            this.cancel();
            this.setDuration(l);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            affineTransform.translate(d2, d3);
            affineTransform.scale(d, d);
            affineTransform.translate(-d2, -d3);
            affineTransform.getMatrix(this.dst);
            Display.this.m_transform.getMatrix(this.src);
            this.run();
        }

        @Override
        protected void run(long l) {
            double d = this.getPace(l);
            Display.this.damageReport();
            Display.this.m_transform.setTransform(this.src[0] + d * (this.dst[0] - this.src[0]), this.src[1] + d * (this.dst[1] - this.src[1]), this.src[2] + d * (this.dst[2] - this.src[2]), this.src[3] + d * (this.dst[3] - this.src[3]), this.src[4] + d * (this.dst[4] - this.src[4]), this.src[5] + d * (this.dst[5] - this.src[5]));
            try {
                Display.this.m_itransform = Display.this.m_transform.createInverse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Display.this.repaint();
        }
    }
}

