/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapmap.util;

import com.schneide.crapmap.util.DelimiterSet;
import java.util.ArrayList;
import java.util.Iterator;

public class StringChunker
implements Iterator<String> {
    private static final DelimiterSet DEFAULT_DELIMITERS = new DelimiterSet(" \t\n\r\f");
    private String text;
    private DelimiterSet delimiters;
    private boolean ignoreMultipleDelimiters;
    private boolean canReturnNull;
    private boolean ignoreLeadingDelimiters;
    private boolean ignoreTrailingDelimiters;
    private int position;
    private String nextChunk;
    private boolean lastPositionChunkProvided;

    public StringChunker(String string) {
        this(string, DEFAULT_DELIMITERS);
    }

    public StringChunker(String string, boolean bl) {
        this(string, DEFAULT_DELIMITERS, bl);
    }

    public StringChunker(String string, String string2) {
        this(string, new DelimiterSet(string2));
    }

    public StringChunker(String string, String string2, boolean bl) throws IllegalArgumentException {
        this(string, new DelimiterSet(string2), bl);
    }

    public StringChunker(String string, DelimiterSet delimiterSet) {
        this(string, delimiterSet, false);
    }

    public StringChunker(String string, DelimiterSet delimiterSet, boolean bl) {
        this.text = string;
        this.delimiters = delimiterSet;
        this.ignoreMultipleDelimiters = bl;
        this.canReturnNull = true;
        this.position = 0;
        this.nextChunk = null;
        this.lastPositionChunkProvided = false;
        this.ignoreLeadingDelimiters = false;
        this.ignoreTrailingDelimiters = false;
    }

    public boolean ignoresMultipleDelimiters() {
        return this.ignoreMultipleDelimiters;
    }

    public void setIgnoreMultipleDelimiters(boolean bl) {
        this.ignoreMultipleDelimiters = bl;
    }

    private int getDelimiterCount() {
        int n = 0;
        while (this.hasCharactersLeft() && this.isCurrentCharacterDelimiter()) {
            ++this.position;
            ++n;
        }
        return n;
    }

    public void setIgnoreLeadingDelimiters(boolean bl) {
        this.ignoreLeadingDelimiters = bl;
    }

    public void setIgnoreTrailingDelimiters(boolean bl) {
        this.ignoreTrailingDelimiters = bl;
    }

    public void setIgnoreLeadingAndTrailingDelimiters(boolean bl) {
        this.setIgnoreLeadingDelimiters(bl);
        this.setIgnoreTrailingDelimiters(bl);
    }

    public boolean ignoresLeadingDelimiters() {
        return this.ignoreLeadingDelimiters;
    }

    public boolean ignoresTrailingDelimiters() {
        return this.ignoreTrailingDelimiters;
    }

    private boolean hasCharactersLeft() {
        return this.position < this.text.length();
    }

    public boolean hasMoreChunks() {
        if (this.text == null) {
            return false;
        }
        if (this.nextChunk != null) {
            return true;
        }
        if (this.position == 0 && this.ignoresLeadingDelimiters()) {
            this.position = this.getDelimiterCount();
        }
        if (this.hasCharactersLeft()) {
            return this.parseNextChunk();
        }
        if (this.wasLastCharacterDelimiter() && !this.lastPositionChunkProvided && !this.ignoreTrailingDelimiters) {
            this.lastPositionChunkProvided = true;
            this.nextChunk = "";
            return true;
        }
        this.nextChunk = null;
        return false;
    }

    private boolean parseNextChunk() {
        int n = this.position;
        int n2 = 0;
        while (this.hasCharactersLeft()) {
            if (this.isCurrentCharacterDelimiter()) {
                ++this.position;
                ++n2;
                if (!this.ignoreMultipleDelimiters) break;
                n2 += this.getDelimiterCount();
                break;
            }
            ++this.position;
        }
        if (n < this.position) {
            int n3 = this.getOffset(n2);
            this.nextChunk = this.text.substring(n, this.position + n3);
            if (this.isIgnoredTrailingDelimiterChunk()) {
                this.nextChunk = null;
                return false;
            }
            return true;
        }
        this.nextChunk = null;
        return false;
    }

    private boolean isIgnoredTrailingDelimiterChunk() {
        return this.ignoresTrailingDelimiters() && this.position > this.text.length() && this.nextChunk.length() == 0;
    }

    private boolean wasLastCharacterDelimiter() {
        if (this.position > 0) {
            return this.isDelimiter(this.text.charAt(this.position - 1));
        }
        return false;
    }

    private boolean isDelimiter(char c) {
        return this.delimiters.isDelimiter(c);
    }

    private boolean isCurrentCharacterDelimiter() {
        char c = this.text.charAt(this.position);
        return this.isDelimiter(c);
    }

    private int getOffset(int n) {
        if (this.delimiters.isHidden()) {
            return -n;
        }
        return 0;
    }

    public String getNextChunk() {
        if (this.hasMoreChunks()) {
            String string = this.nextChunk;
            this.nextChunk = null;
            return string;
        }
        return this.getNullChunk();
    }

    private String getNullChunk() {
        if (this.canReturnNull()) {
            return null;
        }
        return "";
    }

    public void setCanReturnNull(boolean bl) {
        this.canReturnNull = bl;
    }

    public boolean canReturnNull() {
        return this.canReturnNull;
    }

    public int getPosition() {
        return this.position;
    }

    public String getRemainingString() {
        return this.text.substring(this.getPosition());
    }

    public String getLastChunk() {
        String string = null;
        while (this.hasMoreChunks()) {
            string = this.getNextChunk();
        }
        return string;
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreChunks();
    }

    @Override
    public String next() {
        return this.getNextChunk();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String[] getAllChunks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.hasMoreChunks()) {
            arrayList.add(this.getNextChunk());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

