/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapmap.gui;

import com.schneide.crapmap.convert.OverallStatisticsProvider;
import com.schneide.crapmap.gui.CrapTreeMap;
import com.schneide.crapmap.gui.DetailedInfoProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.util.FontLib;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class TreeMapFrameBuilder {
    private final String quickInfoField;
    private final DetailedInfoProvider detailProvider;
    private final OverallStatisticsProvider overallProvider;

    public TreeMapFrameBuilder(String string, OverallStatisticsProvider overallStatisticsProvider, DetailedInfoProvider detailedInfoProvider) {
        this.quickInfoField = string;
        this.overallProvider = overallStatisticsProvider;
        this.detailProvider = detailedInfoProvider;
    }

    public JFrame createFrameFor(CrapTreeMap crapTreeMap, String string) {
        JComponent jComponent = this.createDemoComponent(crapTreeMap);
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(jComponent);
        jFrame.pack();
        return jFrame;
    }

    protected JFastLabel createLabel(int n, int n2) {
        return this.createLabel(n, n2, 20);
    }

    protected JFastLabel createLabel(int n, int n2, int n3) {
        JFastLabel jFastLabel = new JFastLabel("                 ");
        jFastLabel.setPreferredSize(new Dimension(n2, n3));
        jFastLabel.setVerticalAlignment(3);
        jFastLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        jFastLabel.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)n));
        return jFastLabel;
    }

    protected JPanel createDetailPanel(CrapTreeMap crapTreeMap, final JFastLabel jFastLabel) {
        JPanel jPanel = new JPanel(new FlowLayout(3));
        int[] nArray = this.detailProvider.getWidths();
        final JFastLabel[] jFastLabelArray = new JFastLabel[nArray.length];
        for (int i = 0; i < jFastLabelArray.length; ++i) {
            jFastLabelArray[i] = this.createLabel(10, nArray[i], 14);
            jPanel.add((Component)jFastLabelArray[i]);
        }
        crapTreeMap.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
                jFastLabel.setText(visualItem.getString(TreeMapFrameBuilder.this.quickInfoField));
                Iterator<String> iterator = TreeMapFrameBuilder.this.detailProvider.getDetailedInfoFor(visualItem).iterator();
                for (int i = 0; i < jFastLabelArray.length; ++i) {
                    String string = null;
                    if (iterator.hasNext()) {
                        string = iterator.next();
                    }
                    jFastLabelArray[i].setText(string);
                }
            }

            public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
                jFastLabel.setText(null);
                for (int i = 0; i < jFastLabelArray.length; ++i) {
                    jFastLabelArray[i].setText(null);
                }
            }
        });
        return jPanel;
    }

    protected JComponent createDemoComponent(CrapTreeMap crapTreeMap) {
        JSearchPanel jSearchPanel = crapTreeMap.getSearchQuery().createSearchPanel();
        jSearchPanel.setShowResultCount(true);
        jSearchPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        jSearchPanel.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        int n = (int)(crapTreeMap.getSize().getWidth() * 0.75);
        JFastLabel jFastLabel = this.createLabel(16, n);
        JPanel jPanel = this.createDetailPanel(crapTreeMap, jFastLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)jSearchPanel);
        JFastLabel jFastLabel2 = this.createLabel(10, 0, 14);
        JPanel jPanel3 = this.createOverallStatisticsPanel(jFastLabel2);
        Box box = UILib.getBox((Component[])new Component[]{jFastLabel, jPanel}, (boolean)false, (int)10, (int)3, (int)0);
        Box box2 = UILib.getBox((Component[])new Component[]{box, jPanel2}, (boolean)true, (int)10, (int)3, (int)0);
        Box box3 = UILib.getBox((Component[])new Component[]{jPanel3}, (boolean)true, (int)10, (int)3, (int)0);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)((Object)crapTreeMap), "Center");
        jPanel4.add((Component)box2, "South");
        jPanel4.add((Component)box3, "North");
        UILib.setColor((Component)jPanel4, (Color)Color.BLACK, (Color)Color.GRAY);
        jFastLabel2.setForeground(Color.LIGHT_GRAY);
        return jPanel4;
    }

    protected JPanel createOverallStatisticsPanel(JFastLabel jFastLabel) {
        int[] nArray = this.overallProvider.getWidths();
        JFastLabel[] jFastLabelArray = new JFastLabel[nArray.length];
        JPanel jPanel = new JPanel(new FlowLayout(3));
        Iterator<String> iterator = this.overallProvider.getOverallInfo().iterator();
        for (int i = 0; i < jFastLabelArray.length; ++i) {
            jFastLabelArray[i] = this.createLabel(10, nArray[i], 14);
            if (2 == i) {
                jFastLabel.setPreferredSize(jFastLabelArray[i].getPreferredSize());
                jFastLabelArray[i] = jFastLabel;
            }
            jFastLabelArray[i].setText(iterator.next());
            jPanel.add((Component)jFastLabelArray[i]);
        }
        return jPanel;
    }
}

