/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapmap.gui;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataSizeAction;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.SquarifiedTreeMapLayout;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Schema;
import prefuse.data.Tree;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.tuple.TupleSet;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.ColorMap;
import prefuse.util.FontLib;
import prefuse.util.PrefuseLib;
import prefuse.util.UpdateListener;
import prefuse.visual.DecoratorItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTree;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class CrapTreeMap
extends Display {
    private static final long serialVersionUID = 183164065197423095L;
    private static final Schema LABEL_SCHEMA = PrefuseLib.getVisualItemSchema();
    private static final String tree = "tree";
    private static final String treeNodes = "tree.nodes";
    private static final String treeEdges = "tree.edges";
    private static final String labels = "labels";
    private SearchQueryBinding searchQ;
    private final int crapThreshold;

    public CrapTreeMap(Dimension dimension, Tree tree, String string, int n) {
        super(new Visualization());
        this.crapThreshold = n;
        VisualTree visualTree = this.m_vis.addTree(tree, tree);
        this.m_vis.setVisible(treeEdges, null, false);
        Predicate predicate = (Predicate)ExpressionParser.parse((String)"childcount()>0");
        this.m_vis.setInteractive(treeNodes, predicate, false);
        Predicate predicate2 = (Predicate)ExpressionParser.parse((String)"treedepth()=1");
        this.m_vis.addDecorators(labels, treeNodes, predicate2, LABEL_SCHEMA);
        DefaultRendererFactory defaultRendererFactory = new DefaultRendererFactory();
        defaultRendererFactory.add((Predicate)new InGroupPredicate(treeNodes), (Renderer)new NodeRenderer());
        this.m_vis.setRendererFactory((RendererFactory)defaultRendererFactory);
        final BorderColorAction borderColorAction = new BorderColorAction(treeNodes);
        FillColorAction fillColorAction = new FillColorAction(treeNodes);
        ActionList actionList = new ActionList();
        actionList.add((Action)fillColorAction);
        actionList.add((Action)borderColorAction);
        this.m_vis.putAction("colors", (Action)actionList);
        ActionList actionList2 = new ActionList(400L);
        actionList2.add((Action)new ColorAnimator(treeNodes));
        actionList2.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)actionList2);
        ActionList actionList3 = new ActionList();
        actionList3.add((Action)new SquarifiedTreeMapLayout(tree));
        actionList3.add((Action)new LabelLayout(labels));
        actionList3.add((Action)actionList);
        actionList3.add((Action)new RepaintAction());
        this.m_vis.putAction("layout", (Action)actionList3);
        ActionList actionList4 = new ActionList();
        DataSizeAction dataSizeAction = new DataSizeAction(treeNodes, "crap");
        dataSizeAction.setIs2DArea(false);
        actionList4.add((Action)dataSizeAction);
        this.m_vis.putAction("sizes", (Action)actionList4);
        this.setSize(dimension.width, dimension.height);
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
                visualItem.setStrokeColor(borderColorAction.getColor(visualItem));
                visualItem.getVisualization().repaint();
            }

            public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
                visualItem.setStrokeColor(visualItem.getEndStrokeColor());
                visualItem.getVisualization().repaint();
            }
        });
        this.searchQ = new SearchQueryBinding((TupleSet)visualTree.getNodeTable(), string);
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)this.searchQ.getSearchSet());
        this.searchQ.getPredicate().addExpressionListener((ExpressionListener)new UpdateListener(){

            public void update(Object object) {
                CrapTreeMap.this.m_vis.cancel("animatePaint");
                CrapTreeMap.this.m_vis.run("colors");
                CrapTreeMap.this.m_vis.run("animatePaint");
            }
        });
        this.redoLayout();
    }

    public void redoLayout() {
        if (null == this.m_vis) {
            return;
        }
        this.m_vis.run("sizes");
        this.m_vis.run("layout");
    }

    public SearchQueryBinding getSearchQuery() {
        return this.searchQ;
    }

    static {
        LABEL_SCHEMA.setDefault(VisualItem.INTERACTIVE, false);
        LABEL_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)200));
        LABEL_SCHEMA.setDefault(VisualItem.FONT, (Object)FontLib.getFont((String)"Tahoma", (double)16.0));
    }

    public static class NodeRenderer
    extends AbstractShapeRenderer {
        private Rectangle2D m_bounds = new Rectangle2D.Double();

        public NodeRenderer() {
            this.m_manageBounds = false;
        }

        protected Shape getRawShape(VisualItem visualItem) {
            this.m_bounds.setRect(visualItem.getBounds());
            return this.m_bounds;
        }
    }

    public static class LabelLayout
    extends Layout {
        public LabelLayout(String string) {
            super(string);
        }

        public void run(double d) {
            Iterator iterator = this.m_vis.items(this.m_group);
            while (iterator.hasNext()) {
                DecoratorItem decoratorItem = (DecoratorItem)iterator.next();
                VisualItem visualItem = decoratorItem.getDecoratedItem();
                Rectangle2D rectangle2D = visualItem.getBounds();
                this.setX((VisualItem)decoratorItem, null, rectangle2D.getCenterX());
                this.setY((VisualItem)decoratorItem, null, rectangle2D.getCenterY());
            }
        }
    }

    public class FillColorAction
    extends ColorAction {
        private ColorMap cmap;

        public FillColorAction(String string) {
            super(string, VisualItem.FILLCOLOR);
            this.cmap = new ColorMap(ColorLib.getInterpolatedPalette((int)10, (int)ColorLib.rgb((int)85, (int)85, (int)85), (int)ColorLib.rgb((int)0, (int)0, (int)0)), 0.0, 9.0);
        }

        public int getColor(VisualItem visualItem) {
            if (visualItem instanceof NodeItem) {
                NodeItem nodeItem = (NodeItem)visualItem;
                if (nodeItem.getChildCount() > 0) {
                    return 0;
                }
                if (this.m_vis.isInGroup(visualItem, Visualization.SEARCH_ITEMS)) {
                    return ColorLib.rgb((int)191, (int)99, (int)130);
                }
                int n = visualItem.getInt("crapload");
                if (n > 0) {
                    return ColorLib.rgb((int)this.clipRange(10 + n * 15), (int)0, (int)0);
                }
                return ColorLib.rgb((int)0, (int)this.clipRange(CrapTreeMap.this.crapThreshold * 2 - (int)visualItem.getDouble("crap")), (int)0);
            }
            return this.cmap.getColor(0.0);
        }

        protected int clipRange(int n) {
            return Math.max(0, Math.min(255, n));
        }
    }

    public static class BorderColorAction
    extends ColorAction {
        public BorderColorAction(String string) {
            super(string, VisualItem.STROKECOLOR);
        }

        public int getColor(VisualItem visualItem) {
            NodeItem nodeItem = (NodeItem)visualItem;
            if (nodeItem.isHover()) {
                return ColorLib.rgb((int)99, (int)130, (int)191);
            }
            int n = nodeItem.getDepth();
            return ColorLib.gray((int)(255 - n * 60));
        }
    }
}

