/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapmap.convert;

import com.schneide.crap4j.crap.CrapCalculator;
import com.schneide.crap4j.reader.model.ICrap4JReport;
import com.schneide.crap4j.reader.model.ICrapData;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class OverallStatisticsProvider {
    private final DecimalFormat readableFormat;
    private final ICrap4JReport report;

    public OverallStatisticsProvider(ICrap4JReport iCrap4JReport, DecimalFormat decimalFormat) {
        this.report = iCrap4JReport;
        this.readableFormat = decimalFormat;
    }

    public synchronized Iterable<String> getOverallInfo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ICrapData iCrapData = new CrapCalculator().calculateFor(this.report.getMethodCrapManager().getAllCrapData());
        arrayList.add("Method Count: " + iCrapData.getTotalMethods());
        arrayList.add("Crappy Method Count: " + iCrapData.getCrappyMethods());
        arrayList.add("Crappy Method Percentage: " + this.readableFormat.format(iCrapData.getCrapPercentage() * 100.0) + " %");
        arrayList.add("Overall Crap: " + this.readableFormat.format(iCrapData.getCrap()));
        arrayList.add("Overall Crap Load: " + iCrapData.getCrapLoad());
        arrayList.add("Overall Complexity: " + this.readableFormat.format(iCrapData.getComplexity()));
        arrayList.add("Overall Test Coverage: " + this.readableFormat.format(iCrapData.getCoverage()) + " %");
        return arrayList;
    }

    public synchronized int[] getWidths() {
        return new int[]{120, 150, 190, 120, 130, 130, 150};
    }
}

