/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapmap.convert;

import com.schneide.crap4j.crap.ClassCrapData;
import com.schneide.crap4j.crap.PackageCrapData;
import com.schneide.crap4j.reader.PackageManager;
import com.schneide.crap4j.reader.model.IClass;
import com.schneide.crap4j.reader.model.IContextedCrapData;
import com.schneide.crap4j.reader.model.ICrap4JReport;
import com.schneide.crap4j.reader.model.ICrapContext;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IPackage;
import com.schneide.crapmap.gui.DetailedInfoProvider;
import java.io.IOException;
import java.util.ArrayList;
import prefuse.data.Node;
import prefuse.data.Tree;
import prefuse.visual.VisualItem;

public class CrapDataConverter
implements DetailedInfoProvider {
    private final String projectName;
    private final ICrap4JReport data;

    public CrapDataConverter(String string, ICrap4JReport iCrap4JReport) {
        this.projectName = string;
        this.data = iCrap4JReport;
    }

    public Tree createTree() throws IOException {
        PackageCrapData packageCrapData;
        PackageManager packageManager = this.data.getPackageManager();
        IPackage[] iPackageArray = packageManager.getAllPackages();
        double d = 0.0;
        int n = 0;
        ArrayList<IContextedCrapData<? extends ICrapContext>> arrayList = new ArrayList<IContextedCrapData<? extends ICrapContext>>();
        for (int i = 0; i < iPackageArray.length; ++i) {
            packageCrapData = new PackageCrapData(iPackageArray[i], this.data.getMethodCrapManager());
            arrayList.add((IContextedCrapData<? extends ICrapContext>)packageCrapData);
            d += packageCrapData.getCrap();
            n += packageCrapData.getCrapLoad();
        }
        Tree tree = new Tree();
        tree.getNodeTable().addColumn("name", String.class);
        tree.getNodeTable().addColumn("fullname", String.class);
        tree.getNodeTable().addColumn("crap", Double.TYPE);
        tree.getNodeTable().addColumn("crapload", Integer.TYPE);
        tree.getNodeTable().addColumn("complexity", Double.TYPE);
        tree.getNodeTable().addColumn("coverage", Double.TYPE);
        packageCrapData = tree.addRoot();
        this.setupNode((Node)packageCrapData, this.projectName, this.projectName, d, n, 0.0, 0.0);
        this.setupChildrenFor(tree, (Node)packageCrapData, arrayList, new PackageChildrenSetup(this.data));
        return tree;
    }

    protected void setupChildrenFor(Tree tree, Node node, Iterable<IContextedCrapData<? extends ICrapContext>> iterable, ChildrenSetup childrenSetup) {
        for (IContextedCrapData<? extends ICrapContext> iContextedCrapData : iterable) {
            Node node2 = tree.addChild(node);
            this.setupNode(node2, iContextedCrapData);
            childrenSetup.createChildrenFor(tree, node2, iContextedCrapData);
        }
    }

    protected void setupNode(Node node, IContextedCrapData<? extends ICrapContext> iContextedCrapData) {
        this.setupNode(node, iContextedCrapData.getContext().getName(), iContextedCrapData.getContext().getFullName(), iContextedCrapData.getCrap(), iContextedCrapData.getCrapLoad(), iContextedCrapData.getComplexity(), iContextedCrapData.getCoverage());
    }

    protected void setupNode(Node node, String string, String string2, double d, int n, double d2, double d3) {
        node.set("name", (Object)string);
        node.set("fullname", (Object)string2);
        node.set("crap", (Object)d);
        node.set("crapload", (Object)n);
        node.set("complexity", (Object)d2);
        node.set("coverage", (Object)d3);
    }

    @Override
    public Iterable<String> getDetailedInfoFor(VisualItem visualItem) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Method is ");
        if (visualItem.getDouble("crap") < (double)this.data.getCrapThreshold()) {
            stringBuilder.append("not ");
        }
        stringBuilder.append("crappy");
        arrayList.add(stringBuilder.toString());
        arrayList.add("Crap: " + visualItem.getDouble("crap"));
        arrayList.add("Crap Load: " + visualItem.getInt("crapload"));
        arrayList.add("Complexity: " + visualItem.getDouble("complexity"));
        arrayList.add("Test Coverage: " + visualItem.getDouble("coverage"));
        return arrayList;
    }

    @Override
    public int[] getWidths() {
        return new int[]{125, 75, 85, 95, 95};
    }

    protected class NoChildrenSetup
    extends ChildrenSetup {
        public NoChildrenSetup(ICrap4JReport iCrap4JReport) {
            super(iCrap4JReport);
        }

        @Override
        public void createChildrenFor(Tree tree, Node node, IContextedCrapData<? extends ICrapContext> iContextedCrapData) {
        }
    }

    protected class ClassChildrenSetup
    extends ChildrenSetup {
        public ClassChildrenSetup(ICrap4JReport iCrap4JReport) {
            super(iCrap4JReport);
        }

        @Override
        public void createChildrenFor(Tree tree, Node node, IContextedCrapData<? extends ICrapContext> iContextedCrapData) {
            ClassCrapData classCrapData = (ClassCrapData)iContextedCrapData;
            IMethod[] iMethodArray = ((IClass)classCrapData.getContext()).getMethods();
            ArrayList<IContextedCrapData<? extends ICrapContext>> arrayList = new ArrayList<IContextedCrapData<? extends ICrapContext>>();
            for (int i = 0; i < iMethodArray.length; ++i) {
                arrayList.add((IContextedCrapData<? extends ICrapContext>)this.getReport().getMethodCrapManager().getCrapDataFor(iMethodArray[i]));
            }
            CrapDataConverter.this.setupChildrenFor(tree, node, arrayList, new NoChildrenSetup(this.getReport()));
        }
    }

    protected class PackageChildrenSetup
    extends ChildrenSetup {
        public PackageChildrenSetup(ICrap4JReport iCrap4JReport) {
            super(iCrap4JReport);
        }

        @Override
        public void createChildrenFor(Tree tree, Node node, IContextedCrapData<? extends ICrapContext> iContextedCrapData) {
            PackageCrapData packageCrapData = (PackageCrapData)iContextedCrapData;
            IClass[] iClassArray = ((IPackage)packageCrapData.getContext()).getClasses();
            ArrayList<IContextedCrapData<? extends ICrapContext>> arrayList = new ArrayList<IContextedCrapData<? extends ICrapContext>>();
            for (int i = 0; i < iClassArray.length; ++i) {
                arrayList.add((IContextedCrapData<? extends ICrapContext>)new ClassCrapData(iClassArray[i], this.getReport().getMethodCrapManager()));
            }
            CrapDataConverter.this.setupChildrenFor(tree, node, arrayList, new ClassChildrenSetup(this.getReport()));
        }
    }

    protected abstract class ChildrenSetup {
        private final ICrap4JReport report;

        public ChildrenSetup(ICrap4JReport iCrap4JReport) {
            this.report = iCrap4JReport;
        }

        protected final ICrap4JReport getReport() {
            return this.report;
        }

        public abstract void createChildrenFor(Tree var1, Node var2, IContextedCrapData<? extends ICrapContext> var3);
    }
}

