/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crapmap;

import com.schneide.crap4j.reader.ReportReader;
import com.schneide.crap4j.reader.model.ICrap4JReport;
import com.schneide.crapmap.convert.CrapDataConverter;
import com.schneide.crapmap.convert.OverallStatisticsProvider;
import com.schneide.crapmap.gui.CrapTreeMap;
import com.schneide.crapmap.gui.TreeMapFrameBuilder;
import com.schneide.crapmap.util.StringChunker;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileFilter;
import prefuse.util.ui.UILib;

public final class Main {
    private Main() {
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        UILib.setPlatformLookAndFeel();
        if (stringArray.length > 0) {
            string = stringArray[0];
        } else {
            string = Main.selectReportFile();
            if (null == string) {
                return;
            }
        }
        String string2 = Main.determineFromFileName(string);
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        ProgressMonitor progressMonitor = Main.createProgressMonitor();
        JFrame jFrame = Main.buildCrapMapFor(string, string2);
        progressMonitor.close();
        jFrame.setVisible(true);
    }

    protected static ProgressMonitor createProgressMonitor() {
        ProgressMonitor progressMonitor = new ProgressMonitor(null, "Please wait", "Crap4J data is being loaded", 0, 100);
        progressMonitor.setMillisToPopup(0);
        progressMonitor.setMillisToDecideToPopup(0);
        progressMonitor.setProgress(0);
        return progressMonitor;
    }

    protected static String selectReportFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Please select a crap4j report file");
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Crap4J report files (.xml)";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".xml");
            }
        });
        int n = jFileChooser.showOpenDialog(null);
        if (0 != n) {
            return null;
        }
        String string = jFileChooser.getSelectedFile().getAbsolutePath();
        return string;
    }

    protected static Dimension getMapSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.height;
        Dimension dimension2 = new Dimension(n - 150, n - 150);
        return dimension2;
    }

    protected static JFrame buildCrapMapFor(String string, String string2) throws IOException {
        ICrap4JReport iCrap4JReport = Main.loadCrapReport(string);
        CrapDataConverter crapDataConverter = new CrapDataConverter(string2, iCrap4JReport);
        final CrapTreeMap crapTreeMap = new CrapTreeMap(Main.getMapSize(), crapDataConverter.createTree(), "name", iCrap4JReport.getCrapThreshold());
        crapTreeMap.setDamageRedraw(true);
        OverallStatisticsProvider overallStatisticsProvider = new OverallStatisticsProvider(iCrap4JReport, new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ENGLISH)));
        TreeMapFrameBuilder treeMapFrameBuilder = new TreeMapFrameBuilder("fullname", overallStatisticsProvider, crapDataConverter);
        final JFrame jFrame = treeMapFrameBuilder.createFrameFor(crapTreeMap, string2);
        jFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                crapTreeMap.setSize(crapTreeMap.getWidth(), jFrame.getHeight() - 150);
                crapTreeMap.setPreferredSize(crapTreeMap.getSize());
                crapTreeMap.redoLayout();
            }
        });
        return jFrame;
    }

    protected static String determineFromFileName(String string) {
        StringChunker stringChunker = new StringChunker(string, "\\/");
        String string2 = stringChunker.getLastChunk();
        return string2.replace(".xml", "");
    }

    protected static ICrap4JReport loadCrapReport(String string) throws IOException {
        FileReader fileReader = new FileReader(new File(string));
        ReportReader reportReader = new ReportReader((Reader)fileReader);
        ICrap4JReport iCrap4JReport = reportReader.parseData();
        fileReader.close();
        return iCrap4JReport;
    }
}

