/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamPumper {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private StreamPumper() {
    }

    public static long pumpBytes(long l, InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        long l2 = l;
        long l3 = 0L;
        while (l2 > 0L) {
            int n = (int)Math.min(l2, (long)byArray.length);
            int n2 = inputStream.read(byArray, 0, n);
            l2 -= (long)n2;
            l3 += (long)n2;
            outputStream.write(byArray, 0, n2);
        }
        return l3;
    }

    public static String charStreamToString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        while (-1 != (n = inputStream.read())) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static long copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        return StreamPumper.copyBytes(inputStream, outputStream, 4096);
    }

    public static long copyBytes(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return StreamPumper.copyBytes(inputStream, outputStream, new byte[n]);
    }

    public static long copyBytes(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        long l = 0L;
        int n = -1;
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }
}

