/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.util;

public final class Embrace {
    private Embrace() {
    }

    public static String withRoundBrackets(Object object) {
        return Embrace.withBrackets("(", ")", object);
    }

    public static String withParentheses(Object object) {
        return Embrace.withRoundBrackets(object);
    }

    public static String withSquareBrackets(Object object) {
        return Embrace.withBrackets("[", "]", object);
    }

    public static String withBraces(Object object) {
        return Embrace.withCurlyBrackets(object);
    }

    public static String withCurlyBrackets(Object object) {
        return Embrace.withBrackets("{", "}", object);
    }

    public static String withAngleBrackets(Object object) {
        return Embrace.withBrackets("<", ">", object);
    }

    public static String withQuotationMarks(Object object) {
        return Embrace.withDoubleQuotes(object);
    }

    public static String withDoubleQuotes(Object object) {
        return Embrace.withCharacter("\"", object);
    }

    public static String withSingleQuotes(Object object) {
        return Embrace.withCharacter("'", object);
    }

    public static String withCharacter(String string, Object object) {
        return Embrace.withBrackets(string, string, object);
    }

    public static String withString(String string, Object object) {
        return Embrace.withBrackets(string, string, object);
    }

    public static String withBrackets(String string, String string2, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(String.valueOf(object));
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String withXMLTag(String string, String string2) {
        return Embrace.withBrackets(Embrace.withAngleBrackets(string2), Embrace.withAngleBrackets("/" + string2), string);
    }
}

