/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.html.definition;

import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.reader.model.ICrapContext;
import com.schneide.reporting.html.IHTMLTag;
import com.schneide.reporting.html.ScriptTag;
import com.schneide.reporting.html.TableTag;
import com.schneide.reporting.html.TagAttribute;
import com.schneide.reporting.html.definition.ColumnDefinition;
import com.schneide.reporting.html.definition.TableDefinition;
import com.schneide.reporting.util.Embrace;
import java.util.ArrayList;
import java.util.List;

public class SortableTableBuilder<O extends ICrapContext> {
    private String[] getTitlesOf(Iterable<ColumnDefinition<O>> iterable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ColumnDefinition<O> columnDefinition : iterable) {
            arrayList.add(columnDefinition.getTitle());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public IHTMLTag[] createTableFor(TableDefinition<O> tableDefinition, List<GenericCrapData<O>> list) {
        TableTag tableTag = new TableTag(this.getTitlesOf(tableDefinition.getColumns()), new TagAttribute("class", "report"), new TagAttribute("id", tableDefinition.getId()));
        for (GenericCrapData<O> genericCrapData : list) {
            for (ColumnDefinition<O> columnDefinition : tableDefinition.getColumns()) {
                tableTag.addCell(columnDefinition.getTableCellFor(genericCrapData));
            }
        }
        return new IHTMLTag[]{tableTag, this.getSortScriptTag(tableDefinition)};
    }

    private IHTMLTag getSortScriptTag(TableDefinition<O> tableDefinition) {
        ScriptTag scriptTag = new ScriptTag("var packageTable = new SortableTable(document.getElementById(\"" + tableDefinition.getId() + "\"),", "    [" + this.getSortTypesFor(tableDefinition.getColumns()) + "]);", "packageTable.sort(0);");
        return scriptTag;
    }

    private String getSortTypesFor(Iterable<ColumnDefinition<O>> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (ColumnDefinition<O> columnDefinition : iterable) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(Embrace.withDoubleQuotes(columnDefinition.getSortingType()));
        }
        return stringBuilder.toString();
    }
}

