/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.html;

import com.schneide.reporting.html.IHTMLTag;
import com.schneide.reporting.html.TableCell;
import com.schneide.reporting.html.TagAttribute;
import com.schneide.reporting.html.TagBuilder;
import java.util.ArrayList;
import java.util.List;

public class TableTag
implements IHTMLTag {
    private final String[] headers;
    private final int columns;
    private final TagAttribute[] attributes;
    private final List<TableRow> rows;
    private TableRow currentRow;
    private boolean isPrintingTBody;

    public TableTag(String[] stringArray, TagAttribute ... tagAttributeArray) {
        this(stringArray, stringArray.length, tagAttributeArray);
    }

    private TableTag(String[] stringArray, int n, TagAttribute ... tagAttributeArray) {
        this.headers = stringArray;
        this.columns = n;
        this.attributes = tagAttributeArray;
        this.rows = new ArrayList<TableRow>();
        this.isPrintingTBody = true;
        this.openNewRow();
    }

    public void setPrintTBody(boolean bl) {
        this.isPrintingTBody = bl;
    }

    protected TagAttribute[] getTableRowAttributes() {
        return new TagAttribute[0];
    }

    public TableTag(int n, TagAttribute ... tagAttributeArray) {
        this(new String[0], n, tagAttributeArray);
    }

    private void openNewRow() {
        this.currentRow = new TableRow(this.columns, this.getTableRowAttributes());
        this.rows.add(this.currentRow);
    }

    public void addCell(TableCell tableCell) {
        this.currentRow.addCell(tableCell);
        if (this.currentRow.isFull()) {
            this.openNewRow();
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(TagBuilder.getOpeningTag("table", this.attributes));
        stringBuilder.append("\n");
        if (this.headers.length > 0) {
            stringBuilder.append(TagBuilder.getOpeningTag("thead", new TagAttribute[0]));
            stringBuilder.append(TagBuilder.getOpeningTag("tr", new TagAttribute[0]));
            for (String string : this.headers) {
                TableCell tableCell = new TableCell(new TagAttribute("class", "heading"));
                tableCell.addContent(string);
                stringBuilder.append(tableCell);
            }
            stringBuilder.append(TagBuilder.getClosingTag("tr"));
            stringBuilder.append(TagBuilder.getClosingTag("thead"));
        }
        if (this.isPrintingTBody) {
            stringBuilder.append(TagBuilder.getOpeningTag("tbody", new TagAttribute[0]));
            stringBuilder.append("\n");
        }
        for (TableRow tableRow : this.rows) {
            stringBuilder.append(tableRow);
            stringBuilder.append("\n");
        }
        if (this.isPrintingTBody) {
            stringBuilder.append(TagBuilder.getClosingTag("tbody"));
            stringBuilder.append("\n");
        }
        stringBuilder.append(TagBuilder.getClosingTag("table"));
        return stringBuilder.toString();
    }

    private class TableRow {
        private final TableCell[] cells;
        private int currentIndex;
        private final TagAttribute[] rowAttributes;

        public TableRow(int n, TagAttribute[] tagAttributeArray) {
            this.rowAttributes = tagAttributeArray;
            this.currentIndex = 0;
            this.cells = new TableCell[n];
        }

        public boolean isFull() {
            return this.currentIndex >= this.cells.length;
        }

        public boolean isEmpty() {
            return 0 == this.currentIndex;
        }

        public void addCell(TableCell tableCell) {
            this.cells[this.currentIndex] = tableCell;
            ++this.currentIndex;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(TagBuilder.getOpeningTag("tr", this.rowAttributes));
            stringBuilder.append("\n");
            for (int i = 0; i < this.cells.length; ++i) {
                stringBuilder.append(this.cells[i]);
                stringBuilder.append("\n");
            }
            stringBuilder.append(TagBuilder.getClosingTag("tr"));
            return stringBuilder.toString();
        }
    }
}

