/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.drilldown;

import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.reader.model.IClass;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IPackage;
import com.schneide.reporting.drilldown.IFileNameProvider;
import com.schneide.reporting.html.DoubleTargetLinkTag;
import com.schneide.reporting.html.TableCell;
import com.schneide.reporting.html.TagAttribute;
import com.schneide.reporting.html.definition.ColumnDefinition;
import com.schneide.reporting.html.definition.FancyCellBuilder;
import com.schneide.reporting.html.definition.TableDefinition;

public class TableDefiner {
    private final FancyCellBuilder cellBuilder;
    private final IFileNameProvider fileNameProvider;

    public TableDefiner(IFileNameProvider iFileNameProvider) {
        this.fileNameProvider = iFileNameProvider;
        this.cellBuilder = new FancyCellBuilder();
    }

    public TableDefinition<IPackage> definePackageTable() {
        TableDefinition<IPackage> tableDefinition = new TableDefinition<IPackage>("packageResults", new ColumnDefinition[0]);
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Package", "String"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                TableCell tableCell = new TableCell(new TagAttribute[0]);
                if (genericCrapData.getContext().getName().isEmpty()) {
                    tableCell.addContent("<b>All Packages</b>");
                } else {
                    DoubleTargetLinkTag doubleTargetLinkTag = new DoubleTargetLinkTag(TableDefiner.this.fileNameProvider.getDetailPageFor(genericCrapData.getContext()), TableDefiner.this.fileNameProvider.getClassListFor(genericCrapData.getContext()), genericCrapData.getContext().getName(), "summary");
                    tableCell.addContent(doubleTargetLinkTag);
                }
                return tableCell;
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("# Classes", "Number"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getContext().getClasses().length);
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("# Methods", "Number"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getTotalMethods());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Crap Percentage", "Percentage"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                double d = Math.min(1.0, genericCrapData.getCrapPercentage() / 0.15);
                return TableDefiner.this.cellBuilder.getGenericPercentageCell(genericCrapData.getCrapPercentage(), d, genericCrapData.getCrappyMethods(), genericCrapData.getTotalMethods());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Crap Load", "Number"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCrapLoad());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Crap", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCrap());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Coverage", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCoverage());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Complexity", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getComplexity());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Crap Load Ratio", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell((double)genericCrapData.getCrapLoad() / (double)genericCrapData.getTotalMethods());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IPackage>("Crap Ratio", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IPackage> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCrap() / (double)genericCrapData.getTotalMethods());
            }
        });
        return tableDefinition;
    }

    public TableDefinition<IClass> defineClassesTable() {
        return this.defineClassesTable("Classes in this Package");
    }

    public TableDefinition<IClass> defineClassesTable(String string) {
        TableDefinition<IClass> tableDefinition = new TableDefinition<IClass>("classResults", new ColumnDefinition[0]);
        tableDefinition.addColumnDefinition(new ColumnDefinition<IClass>(string, "String"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IClass> genericCrapData) {
                TableCell tableCell = new TableCell(new TagAttribute[0]);
                DoubleTargetLinkTag doubleTargetLinkTag = new DoubleTargetLinkTag(TableDefiner.this.fileNameProvider.getDetailPageFor(genericCrapData.getContext()), TableDefiner.this.fileNameProvider.getClassListFor(genericCrapData.getContext().getPackage()), genericCrapData.getContext().getName(), "summary");
                tableCell.addContent(doubleTargetLinkTag);
                return tableCell;
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IClass>("# Methods", "Number"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IClass> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getContext().getMethods().length);
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IClass>("Crap Percentage", "Percentage"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IClass> genericCrapData) {
                double d = Math.min(1.0, genericCrapData.getCrapPercentage() / 0.15);
                return TableDefiner.this.cellBuilder.getGenericPercentageCell(genericCrapData.getCrapPercentage(), d, genericCrapData.getCrappyMethods(), genericCrapData.getTotalMethods());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IClass>("Crap Load", "Number"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IClass> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCrapLoad());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IClass>("Crap", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IClass> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCrap());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IClass>("Coverage", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IClass> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCoverage());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IClass>("Complexity", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IClass> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getComplexity());
            }
        });
        return tableDefinition;
    }

    private String replaceHTMLControlCharacters(String string) {
        String string2 = string.replace("<", "&lt;");
        string2 = string2.replace(">", "&gt;");
        return string2;
    }

    public TableDefinition<IMethod> defineMethodsTable() {
        TableDefinition<IMethod> tableDefinition = new TableDefinition<IMethod>("methodResults", new ColumnDefinition[0]);
        tableDefinition.addColumnDefinition(new ColumnDefinition<IMethod>("Methods in this Class", "String"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IMethod> genericCrapData) {
                TableCell tableCell = new TableCell(new TagAttribute[0]);
                tableCell.addContent("<b>");
                tableCell.addContent(TableDefiner.this.replaceHTMLControlCharacters(genericCrapData.getContext().getName()));
                tableCell.addContent("</b>");
                return tableCell;
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IMethod>("Crap Percentage", "Percentage"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IMethod> genericCrapData) {
                double d = Math.min(1.0, genericCrapData.getCrapPercentage() / 0.15);
                return TableDefiner.this.cellBuilder.getGenericPercentageCell(genericCrapData.getCrapPercentage(), d, genericCrapData.getCrappyMethods(), genericCrapData.getTotalMethods());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IMethod>("Crap Load", "Number"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IMethod> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCrapLoad());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IMethod>("Crap", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IMethod> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCrap());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IMethod>("Coverage", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IMethod> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getCoverage());
            }
        });
        tableDefinition.addColumnDefinition(new ColumnDefinition<IMethod>("Complexity", "FormattedNumber"){

            @Override
            public TableCell getTableCellFor(GenericCrapData<IMethod> genericCrapData) {
                return TableDefiner.this.cellBuilder.getValueCell(genericCrapData.getComplexity());
            }
        });
        return tableDefinition;
    }
}

