/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.drilldown;

import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.reader.model.IPackage;
import com.schneide.reporting.drilldown.AbstractSummaryRenderer;
import com.schneide.reporting.drilldown.IFileNameProvider;
import com.schneide.reporting.drilldown.TableDefiner;
import com.schneide.reporting.html.H5Tag;
import com.schneide.reporting.html.IHTMLTag;
import com.schneide.reporting.html.SeparatorDivTag;
import com.schneide.reporting.html.definition.SortableTableBuilder;
import java.io.PrintWriter;
import java.util.List;

public class PackagesSummaryRenderer
extends AbstractSummaryRenderer {
    private final List<GenericCrapData<IPackage>> packageData;

    public PackagesSummaryRenderer(IFileNameProvider iFileNameProvider, List<GenericCrapData<IPackage>> list) {
        super(iFileNameProvider);
        this.packageData = list;
    }

    @Override
    protected void renderBodyContent(PrintWriter printWriter) {
        IHTMLTag[] iHTMLTagArray;
        printWriter.println(new H5Tag("Crap Report - All Packages"));
        printWriter.println(new SeparatorDivTag());
        TableDefiner tableDefiner = new TableDefiner(this.getFileNameProvider());
        SortableTableBuilder<IPackage> sortableTableBuilder = new SortableTableBuilder<IPackage>();
        for (IHTMLTag iHTMLTag : iHTMLTagArray = sortableTableBuilder.createTableFor(tableDefiner.definePackageTable(), this.packageData)) {
            printWriter.println(iHTMLTag);
        }
    }
}

