/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.drilldown;

import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.reader.model.IPackage;
import com.schneide.reporting.drilldown.HTMLPageRenderer;
import com.schneide.reporting.drilldown.IFileNameProvider;
import com.schneide.reporting.html.DoubleTargetLinkTag;
import com.schneide.reporting.html.H5Tag;
import com.schneide.reporting.html.TableCell;
import com.schneide.reporting.html.TableTag;
import com.schneide.reporting.html.TagAttribute;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class PackageListRenderer
extends HTMLPageRenderer {
    private final List<GenericCrapData<IPackage>> packageData;
    private final IFileNameProvider fileNameProvider;

    public PackageListRenderer(IFileNameProvider iFileNameProvider, Iterator<GenericCrapData<IPackage>> iterator) {
        this(iFileNameProvider, PackageListRenderer.convertToList(iterator));
    }

    private static List<GenericCrapData<IPackage>> convertToList(Iterator<GenericCrapData<IPackage>> iterator) {
        ArrayList<GenericCrapData<IPackage>> arrayList = new ArrayList<GenericCrapData<IPackage>>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public PackageListRenderer(IFileNameProvider iFileNameProvider, List<GenericCrapData<IPackage>> list) {
        this.fileNameProvider = iFileNameProvider;
        this.packageData = list;
        Collections.sort(this.packageData, new Comparator<GenericCrapData<IPackage>>(){

            @Override
            public int compare(GenericCrapData<IPackage> genericCrapData, GenericCrapData<IPackage> genericCrapData2) {
                return genericCrapData.getContext().getName().compareTo(genericCrapData2.getContext().getName());
            }
        });
    }

    @Override
    protected String getPageTitle() {
        return "Crap Report";
    }

    @Override
    protected String[] getCSSLinks() {
        return new String[]{"css/main.css"};
    }

    @Override
    protected void renderBodyContent(PrintWriter printWriter) {
        printWriter.println(new H5Tag("Packages"));
        TableTag tableTag = new TableTag(1, new TagAttribute("width", "100%"));
        tableTag.addCell(this.renderListEntryFor("All", this.fileNameProvider.getDetailPage(), this.fileNameProvider.getClassList()));
        for (GenericCrapData<IPackage> genericCrapData : this.packageData) {
            TableCell tableCell = this.renderListEntryFor(genericCrapData.getContext());
            tableTag.addCell(tableCell);
        }
        printWriter.println(tableTag);
    }

    private TableCell renderListEntryFor(IPackage iPackage) {
        return this.renderListEntryFor(iPackage.getName(), iPackage);
    }

    private TableCell renderListEntryFor(String string, IPackage iPackage) {
        return this.renderListEntryFor(string, this.fileNameProvider.getDetailPageFor(iPackage), this.fileNameProvider.getClassListFor(iPackage));
    }

    private TableCell renderListEntryFor(String string, String string2, String string3) {
        TableCell tableCell = new TableCell(new TagAttribute("nowrap", "nowrap"));
        DoubleTargetLinkTag doubleTargetLinkTag = new DoubleTargetLinkTag(string2, string3, string, "summary");
        tableCell.addContent(doubleTargetLinkTag);
        return tableCell;
    }
}

