/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.drilldown;

import com.schneide.reporting.html.GenericEnclosingInlineTag;
import com.schneide.reporting.html.TagAttribute;
import java.io.PrintWriter;
import java.io.Writer;

public abstract class HTMLPageRenderer {
    public final void renderTo(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer);
        this.renderPage(printWriter);
        printWriter.flush();
    }

    protected void renderPage(PrintWriter printWriter) {
        this.renderDocType(printWriter);
        this.renderHTMLTag(printWriter);
    }

    protected void renderDocType(PrintWriter printWriter) {
        printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        printWriter.println("           \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
    }

    protected void renderHTMLTag(PrintWriter printWriter) {
        printWriter.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
        this.renderHeadTag(printWriter);
        this.renderBodyTag(printWriter);
        printWriter.println("</html>");
    }

    protected void renderHeadTag(PrintWriter printWriter) {
        printWriter.println("<head>");
        this.renderMetaTags(printWriter);
        this.renderTitleTag(printWriter);
        this.renderCSSLinkTags(printWriter);
        this.renderScriptLinkTags(printWriter);
        printWriter.println("</head>");
    }

    protected void renderBodyTag(PrintWriter printWriter) {
        printWriter.println("<body>");
        this.renderBodyContent(printWriter);
        printWriter.println("</body>");
    }

    protected abstract void renderBodyContent(PrintWriter var1);

    protected void renderMetaTags(PrintWriter printWriter) {
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
    }

    protected void renderTitleTag(PrintWriter printWriter) {
        printWriter.print("<title>");
        printWriter.print(this.getPageTitle());
        printWriter.println("</title>");
    }

    protected abstract String getPageTitle();

    protected void renderCSSLinkTags(PrintWriter printWriter) {
        for (String string : this.getCSSLinks()) {
            printWriter.print("<link title=\"Style\" type=\"text/css\" rel=\"stylesheet\" href=\"");
            printWriter.print(string);
            printWriter.println("\" />");
        }
    }

    protected abstract String[] getCSSLinks();

    protected void renderScriptLinkTags(PrintWriter printWriter) {
        for (String string : this.getScriptLinks()) {
            GenericEnclosingInlineTag genericEnclosingInlineTag = new GenericEnclosingInlineTag("script", "", new TagAttribute("type", "text/javascript"), new TagAttribute("src", string));
            printWriter.println(genericEnclosingInlineTag);
        }
    }

    protected String[] getScriptLinks() {
        return new String[0];
    }
}

