/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.reporting.drilldown;

import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.reader.model.IClass;
import com.schneide.reporting.drilldown.HTMLPageRenderer;
import com.schneide.reporting.html.ATag;
import com.schneide.reporting.html.GenericEnclosingInlineTag;
import com.schneide.reporting.html.H5Tag;
import com.schneide.reporting.html.SeparatorDivTag;
import com.schneide.reporting.html.TableCell;
import com.schneide.reporting.html.TableTag;
import com.schneide.reporting.html.TagAttribute;
import com.schneide.reporting.util.Embrace;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ClassListRenderer
extends HTMLPageRenderer {
    private final List<GenericCrapData<IClass>> classesData;
    private final DecimalFormat percentageFormat;

    public ClassListRenderer(Iterator<GenericCrapData<IClass>> iterator) {
        this(ClassListRenderer.convertToList(iterator));
    }

    private static List<GenericCrapData<IClass>> convertToList(Iterator<GenericCrapData<IClass>> iterator) {
        ArrayList<GenericCrapData<IClass>> arrayList = new ArrayList<GenericCrapData<IClass>>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public ClassListRenderer(List<GenericCrapData<IClass>> list) {
        this.classesData = list;
        this.percentageFormat = new DecimalFormat("0%");
        Collections.sort(this.classesData, new Comparator<GenericCrapData<IClass>>(){

            @Override
            public int compare(GenericCrapData<IClass> genericCrapData, GenericCrapData<IClass> genericCrapData2) {
                return genericCrapData.getContext().getName().compareTo(genericCrapData2.getContext().getName());
            }
        });
    }

    @Override
    protected String getPageTitle() {
        return "Crap Report";
    }

    @Override
    protected String[] getCSSLinks() {
        return new String[]{"css/main.css"};
    }

    @Override
    protected void renderBodyContent(PrintWriter printWriter) {
        printWriter.println(new H5Tag("All Packages"));
        printWriter.println(new SeparatorDivTag());
        printWriter.println(new H5Tag("Classes"));
        TableTag tableTag = new TableTag(1, new TagAttribute("width", "100%"));
        for (GenericCrapData<IClass> genericCrapData : this.classesData) {
            TableCell tableCell = new TableCell(new TagAttribute("nowrap", "nowrap"));
            ATag aTag = new ATag(this.getClassLink(genericCrapData.getContext()), genericCrapData.getContext().getName(), new TagAttribute("target", "summary"));
            GenericEnclosingInlineTag genericEnclosingInlineTag = new GenericEnclosingInlineTag("i", this.getCrapPercentageFor(genericCrapData), new TagAttribute[0]);
            tableCell.addContent(aTag);
            tableCell.addContent(" ");
            tableCell.addContent(genericEnclosingInlineTag);
            tableTag.addCell(tableCell);
        }
        printWriter.println(tableTag);
    }

    private String getCrapPercentageFor(GenericCrapData<IClass> genericCrapData) {
        return Embrace.withParentheses(this.percentageFormat.format(genericCrapData.getCrapPercentage()));
    }

    private String getClassLink(IClass iClass) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iClass.getFullName());
        stringBuilder.append(".html");
        return stringBuilder.toString();
    }
}

