/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.task;

import com.schneide.crap4j.reader.ReportReader;
import com.schneide.crap4j.reader.model.ICrap4JReport;
import com.schneide.crap4j.renderer.CopyContentRenderingJob;
import com.schneide.crap4j.renderer.IRenderingJob;
import com.schneide.crap4j.renderer.ReportGenerator;
import com.schneide.crap4j.renderer.StartPageRenderingJob;
import com.schneide.reporting.drilldown.DefaultFileNameProvider;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Crap4JReportTask
extends Task {
    private File crapReportFile = null;
    private File outputDirectory = null;

    public void setCrapReportFile(File file) {
        this.crapReportFile = file;
    }

    public void setOutputDirectory(File file) {
        this.outputDirectory = file;
    }

    protected void executeHandled() throws Exception {
        this.log("Parsing crap report data from " + this.crapReportFile, 3);
        FileReader fileReader = new FileReader(this.crapReportFile);
        ReportReader reportReader = new ReportReader(fileReader);
        ICrap4JReport iCrap4JReport = reportReader.parseData();
        this.log("Got crap data on " + iCrap4JReport.getMethodManager().getMethodCount() + " methods.", 3);
        this.log("Calculating crap data for " + iCrap4JReport.getClassManager().getClassCount() + " classes.", 3);
        this.log("Calculating crap data for " + iCrap4JReport.getPackageManager().getPackageCount() + " packages.", 3);
        this.log("Rendering report files to " + this.outputDirectory, 3);
        Iterable<IRenderingJob> iterable = new ReportGenerator(new DefaultFileNameProvider()).generateFor(iCrap4JReport);
        int n = this.renderJobs(iterable, new StartPageRenderingJob(), new CopyContentRenderingJob());
        this.log("Rendered " + n + " report files to " + this.outputDirectory, 3);
    }

    private int renderJobs(Iterable<IRenderingJob> iterable, IRenderingJob ... iRenderingJobArray) throws IOException {
        int n = 0;
        for (IRenderingJob iRenderingJob : iterable) {
            iRenderingJob.perform(this.outputDirectory);
            ++n;
        }
        for (IRenderingJob iRenderingJob : iRenderingJobArray) {
            iRenderingJob.perform(this.outputDirectory);
        }
        return n;
    }

    public void execute() throws BuildException {
        this.checkRequirements();
        try {
            this.executeHandled();
        }
        catch (Exception exception) {
            if (exception instanceof BuildException) {
                throw (BuildException)exception;
            }
            throw new BuildException((Throwable)exception, this.getLocation());
        }
    }

    protected void checkRequirements() throws BuildException {
        if (null == this.crapReportFile) {
            throw new BuildException("crapReportFile is required.");
        }
        if (null == this.outputDirectory) {
            throw new BuildException("outputDirectory is required.");
        }
    }
}

