/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.crap4j.renderer;

import com.schneide.crap4j.crap.ClassCrapData;
import com.schneide.crap4j.crap.CrapCalculator;
import com.schneide.crap4j.crap.GenericCrapData;
import com.schneide.crap4j.crap.GenericCrapManager;
import com.schneide.crap4j.crap.PackageCrapData;
import com.schneide.crap4j.reader.model.IClass;
import com.schneide.crap4j.reader.model.ICrap4JReport;
import com.schneide.crap4j.reader.model.IMethod;
import com.schneide.crap4j.reader.model.IPackage;
import com.schneide.crap4j.renderer.IRenderingJob;
import com.schneide.crap4j.renderer.PageRenderingJob;
import com.schneide.reporting.drilldown.ClassListRenderer;
import com.schneide.reporting.drilldown.ClassesSummaryRenderer;
import com.schneide.reporting.drilldown.IFileNameProvider;
import com.schneide.reporting.drilldown.MethodsSummaryRenderer;
import com.schneide.reporting.drilldown.PackageListRenderer;
import com.schneide.reporting.drilldown.PackagesSummaryRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReportGenerator {
    private final IFileNameProvider fileNameProvider;

    public ReportGenerator(IFileNameProvider iFileNameProvider) {
        this.fileNameProvider = iFileNameProvider;
    }

    public Iterable<IRenderingJob> generateFor(ICrap4JReport iCrap4JReport) {
        ArrayList<IRenderingJob> arrayList = new ArrayList<IRenderingJob>();
        GenericCrapManager<IClass> genericCrapManager = new GenericCrapManager<IClass>();
        GenericCrapManager<IPackage> genericCrapManager2 = new GenericCrapManager<IPackage>();
        int n = 0;
        for (IPackage iPackage : iCrap4JReport.getPackageManager().getAllPackages()) {
            PackageCrapData packageCrapData = new PackageCrapData(iPackage, iCrap4JReport.getMethodCrapManager());
            genericCrapManager2.addCrapData(packageCrapData);
            ArrayList<GenericCrapData<IClass>> arrayList2 = new ArrayList<GenericCrapData<IClass>>();
            IClass[] iClassArray = iPackage.getClasses();
            n += iClassArray.length;
            for (IClass iClass : iClassArray) {
                genericCrapManager.addCrapData(new ClassCrapData(iClass, iCrap4JReport.getMethodCrapManager()));
                arrayList2.add(genericCrapManager.getCrapDataFor(iClass));
                ArrayList<GenericCrapData<IMethod>> arrayList3 = new ArrayList<GenericCrapData<IMethod>>();
                for (IMethod iMethod : iClass.getMethods()) {
                    arrayList3.add(iCrap4JReport.getMethodCrapManager().getGenericCrapDataFor(iMethod));
                }
                arrayList.add(new PageRenderingJob(this.getFileNameProvider().getDetailPageFor(iClass), new MethodsSummaryRenderer(this.getFileNameProvider(), packageCrapData, genericCrapManager.getCrapDataFor(iClass), arrayList3)));
            }
            arrayList.add(new PageRenderingJob(this.getFileNameProvider().getClassListFor(iPackage), new ClassListRenderer(arrayList2)));
            arrayList.add(new PageRenderingJob(this.getFileNameProvider().getDetailPageFor(iPackage), new ClassesSummaryRenderer(this.getFileNameProvider(), packageCrapData, arrayList2)));
        }
        arrayList.add(new PageRenderingJob(this.getFileNameProvider().getPackageList(), new PackageListRenderer(this.getFileNameProvider(), genericCrapManager2.getAllCrapData().iterator())));
        arrayList.add(new PageRenderingJob(this.getFileNameProvider().getClassList(), new ClassListRenderer(genericCrapManager.getAllCrapData().iterator())));
        List<GenericCrapData<IPackage>> list = this.convertToList(genericCrapManager2.getAllCrapData().iterator());
        final int n2 = n;
        GenericCrapData<1> genericCrapData = new GenericCrapData<1>(new IPackage(){

            @Override
            public String getName() {
                return "";
            }

            @Override
            public String getFullName() {
                return "";
            }

            @Override
            public IClass[] getClasses() {
                return new IClass[n2];
            }
        }, new CrapCalculator().calculateFor(iCrap4JReport.getMethodCrapManager().getAllCrapData()));
        list.add(0, genericCrapData);
        arrayList.add(new PageRenderingJob(this.getFileNameProvider().getDetailPage(), new PackagesSummaryRenderer(this.getFileNameProvider(), list)));
        return arrayList;
    }

    private IFileNameProvider getFileNameProvider() {
        return this.fileNameProvider;
    }

    private List<GenericCrapData<IPackage>> convertToList(Iterator<GenericCrapData<IPackage>> iterator) {
        ArrayList<GenericCrapData<IPackage>> arrayList = new ArrayList<GenericCrapData<IPackage>>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }
}

